/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.backup.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * BackupVaultListMember JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BackupVaultListMemberJsonUnmarshaller implements Unmarshaller<BackupVaultListMember, JsonUnmarshallerContext> {

    public BackupVaultListMember unmarshall(JsonUnmarshallerContext context) throws Exception {
        BackupVaultListMember backupVaultListMember = new BackupVaultListMember();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BackupVaultName", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setBackupVaultName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BackupVaultArn", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setBackupVaultArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setCreationDate(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("EncryptionKeyArn", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setEncryptionKeyArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatorRequestId", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setCreatorRequestId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfRecoveryPoints", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setNumberOfRecoveryPoints(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Locked", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setLocked(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("MinRetentionDays", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setMinRetentionDays(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("MaxRetentionDays", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setMaxRetentionDays(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("LockDate", targetDepth)) {
                    context.nextToken();
                    backupVaultListMember.setLockDate(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return backupVaultListMember;
    }

    private static BackupVaultListMemberJsonUnmarshaller instance;

    public static BackupVaultListMemberJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new BackupVaultListMemberJsonUnmarshaller();
        return instance;
    }
}
