/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.transform.ReportDestinationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportDestination
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3BucketName;
    private List<String> s3Keys;

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public ReportDestination withS3BucketName(String s3BucketName) {
        this.setS3BucketName(s3BucketName);
        return this;
    }

    public List<String> getS3Keys() {
        return this.s3Keys;
    }

    public void setS3Keys(Collection<String> s3Keys) {
        if (s3Keys == null) {
            this.s3Keys = null;
            return;
        }
        this.s3Keys = new ArrayList<String>(s3Keys);
    }

    public ReportDestination withS3Keys(String ... s3Keys) {
        if (this.s3Keys == null) {
            this.setS3Keys(new ArrayList<String>(s3Keys.length));
        }
        for (String ele : s3Keys) {
            this.s3Keys.add(ele);
        }
        return this;
    }

    public ReportDestination withS3Keys(Collection<String> s3Keys) {
        this.setS3Keys(s3Keys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.getS3BucketName()).append(",");
        }
        if (this.getS3Keys() != null) {
            sb.append("S3Keys: ").append(this.getS3Keys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDestination)) {
            return false;
        }
        ReportDestination other = (ReportDestination)obj;
        if (other.getS3BucketName() == null ^ this.getS3BucketName() == null) {
            return false;
        }
        if (other.getS3BucketName() != null && !other.getS3BucketName().equals(this.getS3BucketName())) {
            return false;
        }
        if (other.getS3Keys() == null ^ this.getS3Keys() == null) {
            return false;
        }
        return other.getS3Keys() == null || other.getS3Keys().equals(this.getS3Keys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3BucketName() == null ? 0 : this.getS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getS3Keys() == null ? 0 : this.getS3Keys().hashCode());
        return hashCode;
    }

    public ReportDestination clone() {
        try {
            return (ReportDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

