/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeReportJobResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of information about a report job, including its completion and creation times, report destination, unique
     * report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     * </p>
     */
    private ReportJob reportJob;

    /**
     * <p>
     * A list of information about a report job, including its completion and creation times, report destination, unique
     * report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     * </p>
     * 
     * @param reportJob
     *        A list of information about a report job, including its completion and creation times, report destination,
     *        unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     */

    public void setReportJob(ReportJob reportJob) {
        this.reportJob = reportJob;
    }

    /**
     * <p>
     * A list of information about a report job, including its completion and creation times, report destination, unique
     * report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     * </p>
     * 
     * @return A list of information about a report job, including its completion and creation times, report
     *         destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status
     *         message.
     */

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    /**
     * <p>
     * A list of information about a report job, including its completion and creation times, report destination, unique
     * report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     * </p>
     * 
     * @param reportJob
     *        A list of information about a report job, including its completion and creation times, report destination,
     *        unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeReportJobResult withReportJob(ReportJob reportJob) {
        setReportJob(reportJob);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReportJob() != null)
            sb.append("ReportJob: ").append(getReportJob());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeReportJobResult == false)
            return false;
        DescribeReportJobResult other = (DescribeReportJobResult) obj;
        if (other.getReportJob() == null ^ this.getReportJob() == null)
            return false;
        if (other.getReportJob() != null && other.getReportJob().equals(this.getReportJob()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReportJob() == null) ? 0 : getReportJob().hashCode());
        return hashCode;
    }

    @Override
    public DescribeReportJobResult clone() {
        try {
            return (DescribeReportJobResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
