/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.backup.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * LifecycleMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class LifecycleMarshaller {

    private static final MarshallingInfo<Long> MOVETOCOLDSTORAGEAFTERDAYS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MoveToColdStorageAfterDays").build();
    private static final MarshallingInfo<Long> DELETEAFTERDAYS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteAfterDays").build();
    private static final MarshallingInfo<Boolean> OPTINTOARCHIVEFORSUPPORTEDRESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OptInToArchiveForSupportedResources").build();

    private static final LifecycleMarshaller instance = new LifecycleMarshaller();

    public static LifecycleMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Lifecycle lifecycle, ProtocolMarshaller protocolMarshaller) {

        if (lifecycle == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(lifecycle.getMoveToColdStorageAfterDays(), MOVETOCOLDSTORAGEAFTERDAYS_BINDING);
            protocolMarshaller.marshall(lifecycle.getDeleteAfterDays(), DELETEAFTERDAYS_BINDING);
            protocolMarshaller.marshall(lifecycle.getOptInToArchiveForSupportedResources(), OPTINTOARCHIVEFORSUPPORTEDRESOURCES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
