/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.backupgateway.AWSBackupGateway;
import com.amazonaws.services.backupgateway.AWSBackupGatewayClientBuilder;
import com.amazonaws.services.backupgateway.model.AWSBackupGatewayException;
import com.amazonaws.services.backupgateway.model.AssociateGatewayToServerRequest;
import com.amazonaws.services.backupgateway.model.AssociateGatewayToServerResult;
import com.amazonaws.services.backupgateway.model.CreateGatewayRequest;
import com.amazonaws.services.backupgateway.model.CreateGatewayResult;
import com.amazonaws.services.backupgateway.model.DeleteGatewayRequest;
import com.amazonaws.services.backupgateway.model.DeleteGatewayResult;
import com.amazonaws.services.backupgateway.model.DeleteHypervisorRequest;
import com.amazonaws.services.backupgateway.model.DeleteHypervisorResult;
import com.amazonaws.services.backupgateway.model.DisassociateGatewayFromServerRequest;
import com.amazonaws.services.backupgateway.model.DisassociateGatewayFromServerResult;
import com.amazonaws.services.backupgateway.model.ImportHypervisorConfigurationRequest;
import com.amazonaws.services.backupgateway.model.ImportHypervisorConfigurationResult;
import com.amazonaws.services.backupgateway.model.ListGatewaysRequest;
import com.amazonaws.services.backupgateway.model.ListGatewaysResult;
import com.amazonaws.services.backupgateway.model.ListHypervisorsRequest;
import com.amazonaws.services.backupgateway.model.ListHypervisorsResult;
import com.amazonaws.services.backupgateway.model.ListTagsForResourceRequest;
import com.amazonaws.services.backupgateway.model.ListTagsForResourceResult;
import com.amazonaws.services.backupgateway.model.ListVirtualMachinesRequest;
import com.amazonaws.services.backupgateway.model.ListVirtualMachinesResult;
import com.amazonaws.services.backupgateway.model.PutMaintenanceStartTimeRequest;
import com.amazonaws.services.backupgateway.model.PutMaintenanceStartTimeResult;
import com.amazonaws.services.backupgateway.model.TagResourceRequest;
import com.amazonaws.services.backupgateway.model.TagResourceResult;
import com.amazonaws.services.backupgateway.model.TestHypervisorConfigurationRequest;
import com.amazonaws.services.backupgateway.model.TestHypervisorConfigurationResult;
import com.amazonaws.services.backupgateway.model.UntagResourceRequest;
import com.amazonaws.services.backupgateway.model.UntagResourceResult;
import com.amazonaws.services.backupgateway.model.UpdateGatewayInformationRequest;
import com.amazonaws.services.backupgateway.model.UpdateGatewayInformationResult;
import com.amazonaws.services.backupgateway.model.UpdateHypervisorRequest;
import com.amazonaws.services.backupgateway.model.UpdateHypervisorResult;
import com.amazonaws.services.backupgateway.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.AssociateGatewayToServerRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.AssociateGatewayToServerResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.CreateGatewayRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.CreateGatewayResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.DeleteGatewayRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.DeleteGatewayResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.DeleteHypervisorRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.DeleteHypervisorResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.DisassociateGatewayFromServerRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.DisassociateGatewayFromServerResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ImportHypervisorConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.ImportHypervisorConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListGatewaysRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListGatewaysResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListHypervisorsRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListHypervisorsResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListVirtualMachinesRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.ListVirtualMachinesResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.PutMaintenanceStartTimeRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.PutMaintenanceStartTimeResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.TestHypervisorConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.TestHypervisorConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.UpdateGatewayInformationRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.UpdateGatewayInformationResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.UpdateHypervisorRequestProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.transform.UpdateHypervisorResultJsonUnmarshaller;
import com.amazonaws.services.backupgateway.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSBackupGatewayClient
extends AmazonWebServiceClient
implements AWSBackupGateway {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSBackupGateway.class);
    private static final String DEFAULT_SIGNING_NAME = "backup-gateway";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSBackupGatewayException.class));

    public static AWSBackupGatewayClientBuilder builder() {
        return AWSBackupGatewayClientBuilder.standard();
    }

    AWSBackupGatewayClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSBackupGatewayClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("backup-gateway.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/backupgateway/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/backupgateway/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateGatewayToServerResult associateGatewayToServer(AssociateGatewayToServerRequest request) {
        request = (AssociateGatewayToServerRequest)this.beforeClientExecution(request);
        return this.executeAssociateGatewayToServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateGatewayToServerResult executeAssociateGatewayToServer(AssociateGatewayToServerRequest associateGatewayToServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateGatewayToServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateGatewayToServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateGatewayToServerRequestProtocolMarshaller(protocolFactory).marshall((AssociateGatewayToServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateGatewayToServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateGatewayToServer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateGatewayToServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateGatewayToServerResult associateGatewayToServerResult = (AssociateGatewayToServerResult)response.getAwsResponse();
            return associateGatewayToServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateGatewayResult createGateway(CreateGatewayRequest request) {
        request = (CreateGatewayRequest)this.beforeClientExecution(request);
        return this.executeCreateGateway(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGatewayResult executeCreateGateway(CreateGatewayRequest createGatewayRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGatewayRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGatewayRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGatewayRequestProtocolMarshaller(protocolFactory).marshall((CreateGatewayRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGatewayRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateGateway");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGatewayResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGatewayResult createGatewayResult = (CreateGatewayResult)response.getAwsResponse();
            return createGatewayResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGatewayResult deleteGateway(DeleteGatewayRequest request) {
        request = (DeleteGatewayRequest)this.beforeClientExecution(request);
        return this.executeDeleteGateway(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGatewayResult executeDeleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGatewayRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGatewayRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGatewayRequestProtocolMarshaller(protocolFactory).marshall((DeleteGatewayRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteGatewayRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteGateway");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGatewayResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGatewayResult deleteGatewayResult = (DeleteGatewayResult)response.getAwsResponse();
            return deleteGatewayResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteHypervisorResult deleteHypervisor(DeleteHypervisorRequest request) {
        request = (DeleteHypervisorRequest)this.beforeClientExecution(request);
        return this.executeDeleteHypervisor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteHypervisorResult executeDeleteHypervisor(DeleteHypervisorRequest deleteHypervisorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHypervisorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHypervisorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHypervisorRequestProtocolMarshaller(protocolFactory).marshall((DeleteHypervisorRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHypervisorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteHypervisor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHypervisorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteHypervisorResult deleteHypervisorResult = (DeleteHypervisorResult)response.getAwsResponse();
            return deleteHypervisorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateGatewayFromServerResult disassociateGatewayFromServer(DisassociateGatewayFromServerRequest request) {
        request = (DisassociateGatewayFromServerRequest)this.beforeClientExecution(request);
        return this.executeDisassociateGatewayFromServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateGatewayFromServerResult executeDisassociateGatewayFromServer(DisassociateGatewayFromServerRequest disassociateGatewayFromServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateGatewayFromServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateGatewayFromServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateGatewayFromServerRequestProtocolMarshaller(protocolFactory).marshall((DisassociateGatewayFromServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateGatewayFromServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateGatewayFromServer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateGatewayFromServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateGatewayFromServerResult disassociateGatewayFromServerResult = (DisassociateGatewayFromServerResult)response.getAwsResponse();
            return disassociateGatewayFromServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportHypervisorConfigurationResult importHypervisorConfiguration(ImportHypervisorConfigurationRequest request) {
        request = (ImportHypervisorConfigurationRequest)this.beforeClientExecution(request);
        return this.executeImportHypervisorConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportHypervisorConfigurationResult executeImportHypervisorConfiguration(ImportHypervisorConfigurationRequest importHypervisorConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importHypervisorConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportHypervisorConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportHypervisorConfigurationRequestProtocolMarshaller(protocolFactory).marshall((ImportHypervisorConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)importHypervisorConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportHypervisorConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportHypervisorConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportHypervisorConfigurationResult importHypervisorConfigurationResult = (ImportHypervisorConfigurationResult)response.getAwsResponse();
            return importHypervisorConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGatewaysResult listGateways(ListGatewaysRequest request) {
        request = (ListGatewaysRequest)this.beforeClientExecution(request);
        return this.executeListGateways(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGatewaysResult executeListGateways(ListGatewaysRequest listGatewaysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGatewaysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGatewaysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGatewaysRequestProtocolMarshaller(protocolFactory).marshall((ListGatewaysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGatewaysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGateways");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGatewaysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGatewaysResult listGatewaysResult = (ListGatewaysResult)response.getAwsResponse();
            return listGatewaysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHypervisorsResult listHypervisors(ListHypervisorsRequest request) {
        request = (ListHypervisorsRequest)this.beforeClientExecution(request);
        return this.executeListHypervisors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHypervisorsResult executeListHypervisors(ListHypervisorsRequest listHypervisorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHypervisorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHypervisorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHypervisorsRequestProtocolMarshaller(protocolFactory).marshall((ListHypervisorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHypervisorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHypervisors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHypervisorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHypervisorsResult listHypervisorsResult = (ListHypervisorsResult)response.getAwsResponse();
            return listHypervisorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVirtualMachinesResult listVirtualMachines(ListVirtualMachinesRequest request) {
        request = (ListVirtualMachinesRequest)this.beforeClientExecution(request);
        return this.executeListVirtualMachines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListVirtualMachinesResult executeListVirtualMachines(ListVirtualMachinesRequest listVirtualMachinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVirtualMachinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVirtualMachinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVirtualMachinesRequestProtocolMarshaller(protocolFactory).marshall((ListVirtualMachinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVirtualMachinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListVirtualMachines");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVirtualMachinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVirtualMachinesResult listVirtualMachinesResult = (ListVirtualMachinesResult)response.getAwsResponse();
            return listVirtualMachinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutMaintenanceStartTimeResult putMaintenanceStartTime(PutMaintenanceStartTimeRequest request) {
        request = (PutMaintenanceStartTimeRequest)this.beforeClientExecution(request);
        return this.executePutMaintenanceStartTime(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutMaintenanceStartTimeResult executePutMaintenanceStartTime(PutMaintenanceStartTimeRequest putMaintenanceStartTimeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMaintenanceStartTimeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutMaintenanceStartTimeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutMaintenanceStartTimeRequestProtocolMarshaller(protocolFactory).marshall((PutMaintenanceStartTimeRequest)super.beforeMarshalling((AmazonWebServiceRequest)putMaintenanceStartTimeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutMaintenanceStartTime");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutMaintenanceStartTimeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutMaintenanceStartTimeResult putMaintenanceStartTimeResult = (PutMaintenanceStartTimeResult)response.getAwsResponse();
            return putMaintenanceStartTimeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TestHypervisorConfigurationResult testHypervisorConfiguration(TestHypervisorConfigurationRequest request) {
        request = (TestHypervisorConfigurationRequest)this.beforeClientExecution(request);
        return this.executeTestHypervisorConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TestHypervisorConfigurationResult executeTestHypervisorConfiguration(TestHypervisorConfigurationRequest testHypervisorConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testHypervisorConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestHypervisorConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestHypervisorConfigurationRequestProtocolMarshaller(protocolFactory).marshall((TestHypervisorConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)testHypervisorConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TestHypervisorConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TestHypervisorConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestHypervisorConfigurationResult testHypervisorConfigurationResult = (TestHypervisorConfigurationResult)response.getAwsResponse();
            return testHypervisorConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateGatewayInformationResult updateGatewayInformation(UpdateGatewayInformationRequest request) {
        request = (UpdateGatewayInformationRequest)this.beforeClientExecution(request);
        return this.executeUpdateGatewayInformation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateGatewayInformationResult executeUpdateGatewayInformation(UpdateGatewayInformationRequest updateGatewayInformationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateGatewayInformationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateGatewayInformationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateGatewayInformationRequestProtocolMarshaller(protocolFactory).marshall((UpdateGatewayInformationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateGatewayInformationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateGatewayInformation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGatewayInformationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateGatewayInformationResult updateGatewayInformationResult = (UpdateGatewayInformationResult)response.getAwsResponse();
            return updateGatewayInformationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateHypervisorResult updateHypervisor(UpdateHypervisorRequest request) {
        request = (UpdateHypervisorRequest)this.beforeClientExecution(request);
        return this.executeUpdateHypervisor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateHypervisorResult executeUpdateHypervisor(UpdateHypervisorRequest updateHypervisorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateHypervisorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateHypervisorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateHypervisorRequestProtocolMarshaller(protocolFactory).marshall((UpdateHypervisorRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateHypervisorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Backup Gateway");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateHypervisor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateHypervisorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateHypervisorResult updateHypervisorResult = (UpdateHypervisorResult)response.getAwsResponse();
            return updateHypervisorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

