/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backupstorage.model.SummaryChecksumAlgorithm;
import com.amazonaws.services.backupstorage.model.transform.BackupObjectMarshaller;
import java.io.Serializable;

public class BackupObject
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Long chunksCount;
    private String metadataString;
    private String objectChecksum;
    private String objectChecksumAlgorithm;
    private String objectToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public BackupObject withName(String name) {
        this.setName(name);
        return this;
    }

    public void setChunksCount(Long chunksCount) {
        this.chunksCount = chunksCount;
    }

    public Long getChunksCount() {
        return this.chunksCount;
    }

    public BackupObject withChunksCount(Long chunksCount) {
        this.setChunksCount(chunksCount);
        return this;
    }

    public void setMetadataString(String metadataString) {
        this.metadataString = metadataString;
    }

    public String getMetadataString() {
        return this.metadataString;
    }

    public BackupObject withMetadataString(String metadataString) {
        this.setMetadataString(metadataString);
        return this;
    }

    public void setObjectChecksum(String objectChecksum) {
        this.objectChecksum = objectChecksum;
    }

    public String getObjectChecksum() {
        return this.objectChecksum;
    }

    public BackupObject withObjectChecksum(String objectChecksum) {
        this.setObjectChecksum(objectChecksum);
        return this;
    }

    public void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
        this.objectChecksumAlgorithm = objectChecksumAlgorithm;
    }

    public String getObjectChecksumAlgorithm() {
        return this.objectChecksumAlgorithm;
    }

    public BackupObject withObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
        this.setObjectChecksumAlgorithm(objectChecksumAlgorithm);
        return this;
    }

    public BackupObject withObjectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
        this.objectChecksumAlgorithm = objectChecksumAlgorithm.toString();
        return this;
    }

    public void setObjectToken(String objectToken) {
        this.objectToken = objectToken;
    }

    public String getObjectToken() {
        return this.objectToken;
    }

    public BackupObject withObjectToken(String objectToken) {
        this.setObjectToken(objectToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getChunksCount() != null) {
            sb.append("ChunksCount: ").append(this.getChunksCount()).append(",");
        }
        if (this.getMetadataString() != null) {
            sb.append("MetadataString: ").append(this.getMetadataString()).append(",");
        }
        if (this.getObjectChecksum() != null) {
            sb.append("ObjectChecksum: ").append(this.getObjectChecksum()).append(",");
        }
        if (this.getObjectChecksumAlgorithm() != null) {
            sb.append("ObjectChecksumAlgorithm: ").append(this.getObjectChecksumAlgorithm()).append(",");
        }
        if (this.getObjectToken() != null) {
            sb.append("ObjectToken: ").append(this.getObjectToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupObject)) {
            return false;
        }
        BackupObject other = (BackupObject)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getChunksCount() == null ^ this.getChunksCount() == null) {
            return false;
        }
        if (other.getChunksCount() != null && !other.getChunksCount().equals(this.getChunksCount())) {
            return false;
        }
        if (other.getMetadataString() == null ^ this.getMetadataString() == null) {
            return false;
        }
        if (other.getMetadataString() != null && !other.getMetadataString().equals(this.getMetadataString())) {
            return false;
        }
        if (other.getObjectChecksum() == null ^ this.getObjectChecksum() == null) {
            return false;
        }
        if (other.getObjectChecksum() != null && !other.getObjectChecksum().equals(this.getObjectChecksum())) {
            return false;
        }
        if (other.getObjectChecksumAlgorithm() == null ^ this.getObjectChecksumAlgorithm() == null) {
            return false;
        }
        if (other.getObjectChecksumAlgorithm() != null && !other.getObjectChecksumAlgorithm().equals(this.getObjectChecksumAlgorithm())) {
            return false;
        }
        if (other.getObjectToken() == null ^ this.getObjectToken() == null) {
            return false;
        }
        return other.getObjectToken() == null || other.getObjectToken().equals(this.getObjectToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getChunksCount() == null ? 0 : this.getChunksCount().hashCode());
        hashCode = 31 * hashCode + (this.getMetadataString() == null ? 0 : this.getMetadataString().hashCode());
        hashCode = 31 * hashCode + (this.getObjectChecksum() == null ? 0 : this.getObjectChecksum().hashCode());
        hashCode = 31 * hashCode + (this.getObjectChecksumAlgorithm() == null ? 0 : this.getObjectChecksumAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getObjectToken() == null ? 0 : this.getObjectToken().hashCode());
        return hashCode;
    }

    public BackupObject clone() {
        try {
            return (BackupObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

