/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrock;

import javax.annotation.Generated;

import com.amazonaws.services.bedrock.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonBedrock}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonBedrock implements AmazonBedrock {

    protected AbstractAmazonBedrock() {
    }

    @Override
    public CreateModelCustomizationJobResult createModelCustomizationJob(CreateModelCustomizationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProvisionedModelThroughputResult createProvisionedModelThroughput(CreateProvisionedModelThroughputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomModelResult deleteCustomModel(DeleteCustomModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelInvocationLoggingConfigurationResult deleteModelInvocationLoggingConfiguration(DeleteModelInvocationLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProvisionedModelThroughputResult deleteProvisionedModelThroughput(DeleteProvisionedModelThroughputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCustomModelResult getCustomModel(GetCustomModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFoundationModelResult getFoundationModel(GetFoundationModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelCustomizationJobResult getModelCustomizationJob(GetModelCustomizationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelInvocationLoggingConfigurationResult getModelInvocationLoggingConfiguration(GetModelInvocationLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProvisionedModelThroughputResult getProvisionedModelThroughput(GetProvisionedModelThroughputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomModelsResult listCustomModels(ListCustomModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFoundationModelsResult listFoundationModels(ListFoundationModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelCustomizationJobsResult listModelCustomizationJobs(ListModelCustomizationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProvisionedModelThroughputsResult listProvisionedModelThroughputs(ListProvisionedModelThroughputsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutModelInvocationLoggingConfigurationResult putModelInvocationLoggingConfiguration(PutModelInvocationLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopModelCustomizationJobResult stopModelCustomizationJob(StopModelCustomizationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProvisionedModelThroughputResult updateProvisionedModelThroughput(UpdateProvisionedModelThroughputRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
