/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagent.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Update Action Group Response
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateAgentActionGroupResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private AgentActionGroup agentActionGroup;

    /**
     * @param agentActionGroup
     */

    public void setAgentActionGroup(AgentActionGroup agentActionGroup) {
        this.agentActionGroup = agentActionGroup;
    }

    /**
     * @return
     */

    public AgentActionGroup getAgentActionGroup() {
        return this.agentActionGroup;
    }

    /**
     * @param agentActionGroup
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateAgentActionGroupResult withAgentActionGroup(AgentActionGroup agentActionGroup) {
        setAgentActionGroup(agentActionGroup);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAgentActionGroup() != null)
            sb.append("AgentActionGroup: ").append(getAgentActionGroup());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateAgentActionGroupResult == false)
            return false;
        UpdateAgentActionGroupResult other = (UpdateAgentActionGroupResult) obj;
        if (other.getAgentActionGroup() == null ^ this.getAgentActionGroup() == null)
            return false;
        if (other.getAgentActionGroup() != null && other.getAgentActionGroup().equals(this.getAgentActionGroup()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAgentActionGroup() == null) ? 0 : getAgentActionGroup().hashCode());
        return hashCode;
    }

    @Override
    public UpdateAgentActionGroupResult clone() {
        try {
            return (UpdateAgentActionGroupResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
