/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagent.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.bedrockagent.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * StorageConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class StorageConfigurationMarshaller {

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("type").build();
    private static final MarshallingInfo<StructuredPojo> OPENSEARCHSERVERLESSCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("opensearchServerlessConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> PINECONECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pineconeConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> REDISENTERPRISECLOUDCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redisEnterpriseCloudConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> RDSCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rdsConfiguration").build();

    private static final StorageConfigurationMarshaller instance = new StorageConfigurationMarshaller();

    public static StorageConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(StorageConfiguration storageConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (storageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(storageConfiguration.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(storageConfiguration.getOpensearchServerlessConfiguration(), OPENSEARCHSERVERLESSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(storageConfiguration.getPineconeConfiguration(), PINECONECONFIGURATION_BINDING);
            protocolMarshaller.marshall(storageConfiguration.getRedisEnterpriseCloudConfiguration(), REDISENTERPRISECLOUDCONFIGURATION_BINDING);
            protocolMarshaller.marshall(storageConfiguration.getRdsConfiguration(), RDSCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
