/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagent.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.bedrockagent.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * VectorKnowledgeBaseConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class VectorKnowledgeBaseConfigurationMarshaller {

    private static final MarshallingInfo<String> EMBEDDINGMODELARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddingModelArn").build();
    private static final MarshallingInfo<StructuredPojo> EMBEDDINGMODELCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddingModelConfiguration").build();

    private static final VectorKnowledgeBaseConfigurationMarshaller instance = new VectorKnowledgeBaseConfigurationMarshaller();

    public static VectorKnowledgeBaseConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(VectorKnowledgeBaseConfiguration vectorKnowledgeBaseConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (vectorKnowledgeBaseConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(vectorKnowledgeBaseConfiguration.getEmbeddingModelArn(), EMBEDDINGMODELARN_BINDING);
            protocolMarshaller.marshall(vectorKnowledgeBaseConfiguration.getEmbeddingModelConfiguration(), EMBEDDINGMODELCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
