/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagentruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Generate response part
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GeneratedResponsePart"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GeneratedResponsePart implements Serializable, Cloneable, StructuredPojo {

    private TextResponsePart textResponsePart;

    /**
     * @param textResponsePart
     */

    public void setTextResponsePart(TextResponsePart textResponsePart) {
        this.textResponsePart = textResponsePart;
    }

    /**
     * @return
     */

    public TextResponsePart getTextResponsePart() {
        return this.textResponsePart;
    }

    /**
     * @param textResponsePart
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GeneratedResponsePart withTextResponsePart(TextResponsePart textResponsePart) {
        setTextResponsePart(textResponsePart);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTextResponsePart() != null)
            sb.append("TextResponsePart: ").append(getTextResponsePart());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GeneratedResponsePart == false)
            return false;
        GeneratedResponsePart other = (GeneratedResponsePart) obj;
        if (other.getTextResponsePart() == null ^ this.getTextResponsePart() == null)
            return false;
        if (other.getTextResponsePart() != null && other.getTextResponsePart().equals(this.getTextResponsePart()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTextResponsePart() == null) ? 0 : getTextResponsePart().hashCode());
        return hashCode;
    }

    @Override
    public GeneratedResponsePart clone() {
        try {
            return (GeneratedResponsePart) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockagentruntime.model.transform.GeneratedResponsePartMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
