/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagentruntime;

import javax.annotation.Generated;

import com.amazonaws.services.bedrockagentruntime.model.*;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.annotation.ThreadSafe;

import java.util.concurrent.ExecutorService;

/**
 * Client for accessing Agents for Amazon Bedrock Runtime asynchronously. Each asynchronous method will return a Java
 * Future object representing the asynchronous operation; overloads which accept an {@code AsyncHandler} can be used to
 * receive notification when an asynchronous operation completes.
 * <p>
 * <p>
 * Contains APIs related to model invocation and querying of knowledge bases.
 * </p>
 */
@ThreadSafe
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AWSBedrockAgentRuntimeAsyncClient extends AWSBedrockAgentRuntimeClient implements AWSBedrockAgentRuntimeAsync {

    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    private final java.util.concurrent.ExecutorService executorService;

    public static AWSBedrockAgentRuntimeAsyncClientBuilder asyncBuilder() {
        return AWSBedrockAgentRuntimeAsyncClientBuilder.standard();
    }

    /**
     * Constructs a new asynchronous client to invoke service methods on Agents for Amazon Bedrock Runtime using the
     * specified parameters.
     *
     * @param asyncClientParams
     *        Object providing client parameters.
     */
    AWSBedrockAgentRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    /**
     * Constructs a new asynchronous client to invoke service methods on Agents for Amazon Bedrock Runtime using the
     * specified parameters.
     *
     * @param asyncClientParams
     *        Object providing client parameters.
     * @param endpointDiscoveryEnabled
     *        true will enable endpoint discovery if the service supports it.
     */
    AWSBedrockAgentRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    /**
     * Returns the executor service used by this client to execute async requests.
     *
     * @return The executor service used by this client to execute async requests.
     */
    public ExecutorService getExecutorService() {
        return executorService;
    }

    @Override
    public java.util.concurrent.Future<DeleteAgentMemoryResult> deleteAgentMemoryAsync(DeleteAgentMemoryRequest request) {

        return deleteAgentMemoryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAgentMemoryResult> deleteAgentMemoryAsync(final DeleteAgentMemoryRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAgentMemoryRequest, DeleteAgentMemoryResult> asyncHandler) {
        final DeleteAgentMemoryRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAgentMemoryResult>() {
            @Override
            public DeleteAgentMemoryResult call() throws Exception {
                DeleteAgentMemoryResult result = null;

                try {
                    result = executeDeleteAgentMemory(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAgentMemoryResult> getAgentMemoryAsync(GetAgentMemoryRequest request) {

        return getAgentMemoryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAgentMemoryResult> getAgentMemoryAsync(final GetAgentMemoryRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAgentMemoryRequest, GetAgentMemoryResult> asyncHandler) {
        final GetAgentMemoryRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAgentMemoryResult>() {
            @Override
            public GetAgentMemoryResult call() throws Exception {
                GetAgentMemoryResult result = null;

                try {
                    result = executeGetAgentMemory(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<RetrieveResult> retrieveAsync(RetrieveRequest request) {

        return retrieveAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RetrieveResult> retrieveAsync(final RetrieveRequest request,
            final com.amazonaws.handlers.AsyncHandler<RetrieveRequest, RetrieveResult> asyncHandler) {
        final RetrieveRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<RetrieveResult>() {
            @Override
            public RetrieveResult call() throws Exception {
                RetrieveResult result = null;

                try {
                    result = executeRetrieve(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<RetrieveAndGenerateResult> retrieveAndGenerateAsync(RetrieveAndGenerateRequest request) {

        return retrieveAndGenerateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RetrieveAndGenerateResult> retrieveAndGenerateAsync(final RetrieveAndGenerateRequest request,
            final com.amazonaws.handlers.AsyncHandler<RetrieveAndGenerateRequest, RetrieveAndGenerateResult> asyncHandler) {
        final RetrieveAndGenerateRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<RetrieveAndGenerateResult>() {
            @Override
            public RetrieveAndGenerateResult call() throws Exception {
                RetrieveAndGenerateResult result = null;

                try {
                    result = executeRetrieveAndGenerate(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    /**
     * Shuts down the client, releasing all managed resources. This includes forcibly terminating all pending
     * asynchronous service calls. Clients who wish to give pending asynchronous service calls time to complete should
     * call {@code getExecutorService().shutdown()} followed by {@code getExecutorService().awaitTermination()} prior to
     * calling this method.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        executorService.shutdownNow();
    }
}
