/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagentruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Configuration settings for text generation using a language model via the RetrieveAndGenerate operation. Includes
 * parameters like temperature, top-p, maximum token count, and stop sequences.
 * </p>
 * <note>
 * <p>
 * The valid range of <code>maxTokens</code> depends on the accepted values for your chosen model's inference
 * parameters. To see the inference parameters for your model, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation
 * models.</a>
 * </p>
 * </note>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/TextInferenceConfig"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TextInferenceConfig implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of 65536.
     * The limit values described here are arbitary values, for actual values consult the limits defined by your
     * specific model.
     * </p>
     */
    private Integer maxTokens;
    /**
     * <p>
     * A list of sequences of characters that, if generated, will cause the model to stop generating further tokens. Do
     * not use a minimum length of 1 or a maximum length of 1000. The limit values described here are arbitary values,
     * for actual values consult the limits defined by your specific model.
     * </p>
     */
    private java.util.List<String> stopSequences;
    /**
     * <p>
     * Controls the random-ness of text generated by the language model, influencing how much the model sticks to the
     * most predictable next words versus exploring more surprising options. A lower temperature value (e.g. 0.2 or 0.3)
     * makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or 0.9) makes the
     * outputs more creative or unpredictable.
     * </p>
     */
    private Float temperature;
    /**
     * <p>
     * A probability distribution threshold which controls what the model considers for the set of possible next tokens.
     * The model will only consider the top p% of the probability distribution when generating the next token.
     * </p>
     */
    private Float topP;

    /**
     * <p>
     * The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of 65536.
     * The limit values described here are arbitary values, for actual values consult the limits defined by your
     * specific model.
     * </p>
     * 
     * @param maxTokens
     *        The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of
     *        65536. The limit values described here are arbitary values, for actual values consult the limits defined
     *        by your specific model.
     */

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    /**
     * <p>
     * The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of 65536.
     * The limit values described here are arbitary values, for actual values consult the limits defined by your
     * specific model.
     * </p>
     * 
     * @return The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum
     *         of 65536. The limit values described here are arbitary values, for actual values consult the limits
     *         defined by your specific model.
     */

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    /**
     * <p>
     * The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of 65536.
     * The limit values described here are arbitary values, for actual values consult the limits defined by your
     * specific model.
     * </p>
     * 
     * @param maxTokens
     *        The maximum number of tokens to generate in the output text. Do not use the minimum of 0 or the maximum of
     *        65536. The limit values described here are arbitary values, for actual values consult the limits defined
     *        by your specific model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TextInferenceConfig withMaxTokens(Integer maxTokens) {
        setMaxTokens(maxTokens);
        return this;
    }

    /**
     * <p>
     * A list of sequences of characters that, if generated, will cause the model to stop generating further tokens. Do
     * not use a minimum length of 1 or a maximum length of 1000. The limit values described here are arbitary values,
     * for actual values consult the limits defined by your specific model.
     * </p>
     * 
     * @return A list of sequences of characters that, if generated, will cause the model to stop generating further
     *         tokens. Do not use a minimum length of 1 or a maximum length of 1000. The limit values described here are
     *         arbitary values, for actual values consult the limits defined by your specific model.
     */

    public java.util.List<String> getStopSequences() {
        return stopSequences;
    }

    /**
     * <p>
     * A list of sequences of characters that, if generated, will cause the model to stop generating further tokens. Do
     * not use a minimum length of 1 or a maximum length of 1000. The limit values described here are arbitary values,
     * for actual values consult the limits defined by your specific model.
     * </p>
     * 
     * @param stopSequences
     *        A list of sequences of characters that, if generated, will cause the model to stop generating further
     *        tokens. Do not use a minimum length of 1 or a maximum length of 1000. The limit values described here are
     *        arbitary values, for actual values consult the limits defined by your specific model.
     */

    public void setStopSequences(java.util.Collection<String> stopSequences) {
        if (stopSequences == null) {
            this.stopSequences = null;
            return;
        }

        this.stopSequences = new java.util.ArrayList<String>(stopSequences);
    }

    /**
     * <p>
     * A list of sequences of characters that, if generated, will cause the model to stop generating further tokens. Do
     * not use a minimum length of 1 or a maximum length of 1000. The limit values described here are arbitary values,
     * for actual values consult the limits defined by your specific model.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStopSequences(java.util.Collection)} or {@link #withStopSequences(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param stopSequences
     *        A list of sequences of characters that, if generated, will cause the model to stop generating further
     *        tokens. Do not use a minimum length of 1 or a maximum length of 1000. The limit values described here are
     *        arbitary values, for actual values consult the limits defined by your specific model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TextInferenceConfig withStopSequences(String... stopSequences) {
        if (this.stopSequences == null) {
            setStopSequences(new java.util.ArrayList<String>(stopSequences.length));
        }
        for (String ele : stopSequences) {
            this.stopSequences.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of sequences of characters that, if generated, will cause the model to stop generating further tokens. Do
     * not use a minimum length of 1 or a maximum length of 1000. The limit values described here are arbitary values,
     * for actual values consult the limits defined by your specific model.
     * </p>
     * 
     * @param stopSequences
     *        A list of sequences of characters that, if generated, will cause the model to stop generating further
     *        tokens. Do not use a minimum length of 1 or a maximum length of 1000. The limit values described here are
     *        arbitary values, for actual values consult the limits defined by your specific model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TextInferenceConfig withStopSequences(java.util.Collection<String> stopSequences) {
        setStopSequences(stopSequences);
        return this;
    }

    /**
     * <p>
     * Controls the random-ness of text generated by the language model, influencing how much the model sticks to the
     * most predictable next words versus exploring more surprising options. A lower temperature value (e.g. 0.2 or 0.3)
     * makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or 0.9) makes the
     * outputs more creative or unpredictable.
     * </p>
     * 
     * @param temperature
     *        Controls the random-ness of text generated by the language model, influencing how much the model sticks to
     *        the most predictable next words versus exploring more surprising options. A lower temperature value (e.g.
     *        0.2 or 0.3) makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or
     *        0.9) makes the outputs more creative or unpredictable.
     */

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    /**
     * <p>
     * Controls the random-ness of text generated by the language model, influencing how much the model sticks to the
     * most predictable next words versus exploring more surprising options. A lower temperature value (e.g. 0.2 or 0.3)
     * makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or 0.9) makes the
     * outputs more creative or unpredictable.
     * </p>
     * 
     * @return Controls the random-ness of text generated by the language model, influencing how much the model sticks
     *         to the most predictable next words versus exploring more surprising options. A lower temperature value
     *         (e.g. 0.2 or 0.3) makes model outputs more deterministic or predictable, while a higher temperature (e.g.
     *         0.8 or 0.9) makes the outputs more creative or unpredictable.
     */

    public Float getTemperature() {
        return this.temperature;
    }

    /**
     * <p>
     * Controls the random-ness of text generated by the language model, influencing how much the model sticks to the
     * most predictable next words versus exploring more surprising options. A lower temperature value (e.g. 0.2 or 0.3)
     * makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or 0.9) makes the
     * outputs more creative or unpredictable.
     * </p>
     * 
     * @param temperature
     *        Controls the random-ness of text generated by the language model, influencing how much the model sticks to
     *        the most predictable next words versus exploring more surprising options. A lower temperature value (e.g.
     *        0.2 or 0.3) makes model outputs more deterministic or predictable, while a higher temperature (e.g. 0.8 or
     *        0.9) makes the outputs more creative or unpredictable.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TextInferenceConfig withTemperature(Float temperature) {
        setTemperature(temperature);
        return this;
    }

    /**
     * <p>
     * A probability distribution threshold which controls what the model considers for the set of possible next tokens.
     * The model will only consider the top p% of the probability distribution when generating the next token.
     * </p>
     * 
     * @param topP
     *        A probability distribution threshold which controls what the model considers for the set of possible next
     *        tokens. The model will only consider the top p% of the probability distribution when generating the next
     *        token.
     */

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    /**
     * <p>
     * A probability distribution threshold which controls what the model considers for the set of possible next tokens.
     * The model will only consider the top p% of the probability distribution when generating the next token.
     * </p>
     * 
     * @return A probability distribution threshold which controls what the model considers for the set of possible next
     *         tokens. The model will only consider the top p% of the probability distribution when generating the next
     *         token.
     */

    public Float getTopP() {
        return this.topP;
    }

    /**
     * <p>
     * A probability distribution threshold which controls what the model considers for the set of possible next tokens.
     * The model will only consider the top p% of the probability distribution when generating the next token.
     * </p>
     * 
     * @param topP
     *        A probability distribution threshold which controls what the model considers for the set of possible next
     *        tokens. The model will only consider the top p% of the probability distribution when generating the next
     *        token.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TextInferenceConfig withTopP(Float topP) {
        setTopP(topP);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMaxTokens() != null)
            sb.append("MaxTokens: ").append(getMaxTokens()).append(",");
        if (getStopSequences() != null)
            sb.append("StopSequences: ").append(getStopSequences()).append(",");
        if (getTemperature() != null)
            sb.append("Temperature: ").append(getTemperature()).append(",");
        if (getTopP() != null)
            sb.append("TopP: ").append(getTopP());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TextInferenceConfig == false)
            return false;
        TextInferenceConfig other = (TextInferenceConfig) obj;
        if (other.getMaxTokens() == null ^ this.getMaxTokens() == null)
            return false;
        if (other.getMaxTokens() != null && other.getMaxTokens().equals(this.getMaxTokens()) == false)
            return false;
        if (other.getStopSequences() == null ^ this.getStopSequences() == null)
            return false;
        if (other.getStopSequences() != null && other.getStopSequences().equals(this.getStopSequences()) == false)
            return false;
        if (other.getTemperature() == null ^ this.getTemperature() == null)
            return false;
        if (other.getTemperature() != null && other.getTemperature().equals(this.getTemperature()) == false)
            return false;
        if (other.getTopP() == null ^ this.getTopP() == null)
            return false;
        if (other.getTopP() != null && other.getTopP().equals(this.getTopP()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMaxTokens() == null) ? 0 : getMaxTokens().hashCode());
        hashCode = prime * hashCode + ((getStopSequences() == null) ? 0 : getStopSequences().hashCode());
        hashCode = prime * hashCode + ((getTemperature() == null) ? 0 : getTemperature().hashCode());
        hashCode = prime * hashCode + ((getTopP() == null) ? 0 : getTopP().hashCode());
        return hashCode;
    }

    @Override
    public TextInferenceConfig clone() {
        try {
            return (TextInferenceConfig) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockagentruntime.model.transform.TextInferenceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
