/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/Converse" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ConverseResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The result from the call to <code>Converse</code>.
     * </p>
     */
    private ConverseOutput output;
    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     */
    private String stopReason;
    /**
     * <p>
     * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the
     * model and the tokens generated by the model.
     * </p>
     */
    private TokenUsage usage;
    /**
     * <p>
     * Metrics for the call to <code>Converse</code>.
     * </p>
     */
    private ConverseMetrics metrics;

    /**
     * <p>
     * The result from the call to <code>Converse</code>.
     * </p>
     * 
     * @param output
     *        The result from the call to <code>Converse</code>.
     */

    public void setOutput(ConverseOutput output) {
        this.output = output;
    }

    /**
     * <p>
     * The result from the call to <code>Converse</code>.
     * </p>
     * 
     * @return The result from the call to <code>Converse</code>.
     */

    public ConverseOutput getOutput() {
        return this.output;
    }

    /**
     * <p>
     * The result from the call to <code>Converse</code>.
     * </p>
     * 
     * @param output
     *        The result from the call to <code>Converse</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConverseResult withOutput(ConverseOutput output) {
        setOutput(output);
        return this;
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * 
     * @param stopReason
     *        The reason why the model stopped generating output.
     * @see StopReason
     */

    public void setStopReason(String stopReason) {
        this.stopReason = stopReason;
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * 
     * @return The reason why the model stopped generating output.
     * @see StopReason
     */

    public String getStopReason() {
        return this.stopReason;
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * 
     * @param stopReason
     *        The reason why the model stopped generating output.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StopReason
     */

    public ConverseResult withStopReason(String stopReason) {
        setStopReason(stopReason);
        return this;
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * 
     * @param stopReason
     *        The reason why the model stopped generating output.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StopReason
     */

    public ConverseResult withStopReason(StopReason stopReason) {
        this.stopReason = stopReason.toString();
        return this;
    }

    /**
     * <p>
     * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the
     * model and the tokens generated by the model.
     * </p>
     * 
     * @param usage
     *        The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input
     *        to the model and the tokens generated by the model.
     */

    public void setUsage(TokenUsage usage) {
        this.usage = usage;
    }

    /**
     * <p>
     * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the
     * model and the tokens generated by the model.
     * </p>
     * 
     * @return The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input
     *         to the model and the tokens generated by the model.
     */

    public TokenUsage getUsage() {
        return this.usage;
    }

    /**
     * <p>
     * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the
     * model and the tokens generated by the model.
     * </p>
     * 
     * @param usage
     *        The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input
     *        to the model and the tokens generated by the model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConverseResult withUsage(TokenUsage usage) {
        setUsage(usage);
        return this;
    }

    /**
     * <p>
     * Metrics for the call to <code>Converse</code>.
     * </p>
     * 
     * @param metrics
     *        Metrics for the call to <code>Converse</code>.
     */

    public void setMetrics(ConverseMetrics metrics) {
        this.metrics = metrics;
    }

    /**
     * <p>
     * Metrics for the call to <code>Converse</code>.
     * </p>
     * 
     * @return Metrics for the call to <code>Converse</code>.
     */

    public ConverseMetrics getMetrics() {
        return this.metrics;
    }

    /**
     * <p>
     * Metrics for the call to <code>Converse</code>.
     * </p>
     * 
     * @param metrics
     *        Metrics for the call to <code>Converse</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ConverseResult withMetrics(ConverseMetrics metrics) {
        setMetrics(metrics);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOutput() != null)
            sb.append("Output: ").append(getOutput()).append(",");
        if (getStopReason() != null)
            sb.append("StopReason: ").append(getStopReason()).append(",");
        if (getUsage() != null)
            sb.append("Usage: ").append(getUsage()).append(",");
        if (getMetrics() != null)
            sb.append("Metrics: ").append(getMetrics());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ConverseResult == false)
            return false;
        ConverseResult other = (ConverseResult) obj;
        if (other.getOutput() == null ^ this.getOutput() == null)
            return false;
        if (other.getOutput() != null && other.getOutput().equals(this.getOutput()) == false)
            return false;
        if (other.getStopReason() == null ^ this.getStopReason() == null)
            return false;
        if (other.getStopReason() != null && other.getStopReason().equals(this.getStopReason()) == false)
            return false;
        if (other.getUsage() == null ^ this.getUsage() == null)
            return false;
        if (other.getUsage() != null && other.getUsage().equals(this.getUsage()) == false)
            return false;
        if (other.getMetrics() == null ^ this.getMetrics() == null)
            return false;
        if (other.getMetrics() != null && other.getMetrics().equals(this.getMetrics()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOutput() == null) ? 0 : getOutput().hashCode());
        hashCode = prime * hashCode + ((getStopReason() == null) ? 0 : getStopReason().hashCode());
        hashCode = prime * hashCode + ((getUsage() == null) ? 0 : getUsage().hashCode());
        hashCode = prime * hashCode + ((getMetrics() == null) ? 0 : getMetrics().hashCode());
        return hashCode;
    }

    @Override
    public ConverseResult clone() {
        try {
            return (ConverseResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
