/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bedrockruntime.model.GuardrailConfiguration;
import com.amazonaws.services.bedrockruntime.model.InferenceConfiguration;
import com.amazonaws.services.bedrockruntime.model.Message;
import com.amazonaws.services.bedrockruntime.model.SystemContentBlock;
import com.amazonaws.services.bedrockruntime.model.ToolConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConverseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelId;
    private List<Message> messages;
    private List<SystemContentBlock> system;
    private InferenceConfiguration inferenceConfig;
    private ToolConfiguration toolConfig;
    private GuardrailConfiguration guardrailConfig;
    private List<String> additionalModelResponseFieldPaths;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public ConverseRequest withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public ConverseRequest withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public ConverseRequest withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public List<SystemContentBlock> getSystem() {
        return this.system;
    }

    public void setSystem(Collection<SystemContentBlock> system) {
        if (system == null) {
            this.system = null;
            return;
        }
        this.system = new ArrayList<SystemContentBlock>(system);
    }

    public ConverseRequest withSystem(SystemContentBlock ... system) {
        if (this.system == null) {
            this.setSystem(new ArrayList<SystemContentBlock>(system.length));
        }
        for (SystemContentBlock ele : system) {
            this.system.add(ele);
        }
        return this;
    }

    public ConverseRequest withSystem(Collection<SystemContentBlock> system) {
        this.setSystem(system);
        return this;
    }

    public void setInferenceConfig(InferenceConfiguration inferenceConfig) {
        this.inferenceConfig = inferenceConfig;
    }

    public InferenceConfiguration getInferenceConfig() {
        return this.inferenceConfig;
    }

    public ConverseRequest withInferenceConfig(InferenceConfiguration inferenceConfig) {
        this.setInferenceConfig(inferenceConfig);
        return this;
    }

    public void setToolConfig(ToolConfiguration toolConfig) {
        this.toolConfig = toolConfig;
    }

    public ToolConfiguration getToolConfig() {
        return this.toolConfig;
    }

    public ConverseRequest withToolConfig(ToolConfiguration toolConfig) {
        this.setToolConfig(toolConfig);
        return this;
    }

    public void setGuardrailConfig(GuardrailConfiguration guardrailConfig) {
        this.guardrailConfig = guardrailConfig;
    }

    public GuardrailConfiguration getGuardrailConfig() {
        return this.guardrailConfig;
    }

    public ConverseRequest withGuardrailConfig(GuardrailConfiguration guardrailConfig) {
        this.setGuardrailConfig(guardrailConfig);
        return this;
    }

    public List<String> getAdditionalModelResponseFieldPaths() {
        return this.additionalModelResponseFieldPaths;
    }

    public void setAdditionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
        if (additionalModelResponseFieldPaths == null) {
            this.additionalModelResponseFieldPaths = null;
            return;
        }
        this.additionalModelResponseFieldPaths = new ArrayList<String>(additionalModelResponseFieldPaths);
    }

    public ConverseRequest withAdditionalModelResponseFieldPaths(String ... additionalModelResponseFieldPaths) {
        if (this.additionalModelResponseFieldPaths == null) {
            this.setAdditionalModelResponseFieldPaths(new ArrayList<String>(additionalModelResponseFieldPaths.length));
        }
        for (String ele : additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths.add(ele);
        }
        return this;
    }

    public ConverseRequest withAdditionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
        this.setAdditionalModelResponseFieldPaths(additionalModelResponseFieldPaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getSystem() != null) {
            sb.append("System: ").append(this.getSystem()).append(",");
        }
        if (this.getInferenceConfig() != null) {
            sb.append("InferenceConfig: ").append(this.getInferenceConfig()).append(",");
        }
        if (this.getToolConfig() != null) {
            sb.append("ToolConfig: ").append(this.getToolConfig()).append(",");
        }
        if (this.getGuardrailConfig() != null) {
            sb.append("GuardrailConfig: ").append(this.getGuardrailConfig()).append(",");
        }
        if (this.getAdditionalModelResponseFieldPaths() != null) {
            sb.append("AdditionalModelResponseFieldPaths: ").append(this.getAdditionalModelResponseFieldPaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseRequest)) {
            return false;
        }
        ConverseRequest other = (ConverseRequest)obj;
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getSystem() == null ^ this.getSystem() == null) {
            return false;
        }
        if (other.getSystem() != null && !other.getSystem().equals(this.getSystem())) {
            return false;
        }
        if (other.getInferenceConfig() == null ^ this.getInferenceConfig() == null) {
            return false;
        }
        if (other.getInferenceConfig() != null && !other.getInferenceConfig().equals(this.getInferenceConfig())) {
            return false;
        }
        if (other.getToolConfig() == null ^ this.getToolConfig() == null) {
            return false;
        }
        if (other.getToolConfig() != null && !other.getToolConfig().equals(this.getToolConfig())) {
            return false;
        }
        if (other.getGuardrailConfig() == null ^ this.getGuardrailConfig() == null) {
            return false;
        }
        if (other.getGuardrailConfig() != null && !other.getGuardrailConfig().equals(this.getGuardrailConfig())) {
            return false;
        }
        if (other.getAdditionalModelResponseFieldPaths() == null ^ this.getAdditionalModelResponseFieldPaths() == null) {
            return false;
        }
        return other.getAdditionalModelResponseFieldPaths() == null || other.getAdditionalModelResponseFieldPaths().equals(this.getAdditionalModelResponseFieldPaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getSystem() == null ? 0 : this.getSystem().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceConfig() == null ? 0 : this.getInferenceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getToolConfig() == null ? 0 : this.getToolConfig().hashCode());
        hashCode = 31 * hashCode + (this.getGuardrailConfig() == null ? 0 : this.getGuardrailConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalModelResponseFieldPaths() == null ? 0 : this.getAdditionalModelResponseFieldPaths().hashCode());
        return hashCode;
    }

    public ConverseRequest clone() {
        return (ConverseRequest)super.clone();
    }
}

