/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockruntime.model.InferenceConfiguration;
import java.util.List;

@SdkInternalApi
public class InferenceConfigurationMarshaller {
    private static final MarshallingInfo<Integer> MAXTOKENS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxTokens").build();
    private static final MarshallingInfo<Float> TEMPERATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temperature").build();
    private static final MarshallingInfo<Float> TOPP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topP").build();
    private static final MarshallingInfo<List> STOPSEQUENCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopSequences").build();
    private static final InferenceConfigurationMarshaller instance = new InferenceConfigurationMarshaller();

    public static InferenceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InferenceConfiguration inferenceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (inferenceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inferenceConfiguration.getMaxTokens(), MAXTOKENS_BINDING);
            protocolMarshaller.marshall((Object)inferenceConfiguration.getTemperature(), TEMPERATURE_BINDING);
            protocolMarshaller.marshall((Object)inferenceConfiguration.getTopP(), TOPP_BINDING);
            protocolMarshaller.marshall(inferenceConfiguration.getStopSequences(), STOPSEQUENCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

