/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A Personally Identifiable Information (PII) entity configured in a guardrail.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GuardrailPiiEntityFilter"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GuardrailPiiEntityFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The PII entity filter match.
     * </p>
     */
    private String match;
    /**
     * <p>
     * The PII entity filter type.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The PII entity filter action.
     * </p>
     */
    private String action;

    /**
     * <p>
     * The PII entity filter match.
     * </p>
     * 
     * @param match
     *        The PII entity filter match.
     */

    public void setMatch(String match) {
        this.match = match;
    }

    /**
     * <p>
     * The PII entity filter match.
     * </p>
     * 
     * @return The PII entity filter match.
     */

    public String getMatch() {
        return this.match;
    }

    /**
     * <p>
     * The PII entity filter match.
     * </p>
     * 
     * @param match
     *        The PII entity filter match.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GuardrailPiiEntityFilter withMatch(String match) {
        setMatch(match);
        return this;
    }

    /**
     * <p>
     * The PII entity filter type.
     * </p>
     * 
     * @param type
     *        The PII entity filter type.
     * @see GuardrailPiiEntityType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The PII entity filter type.
     * </p>
     * 
     * @return The PII entity filter type.
     * @see GuardrailPiiEntityType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The PII entity filter type.
     * </p>
     * 
     * @param type
     *        The PII entity filter type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailPiiEntityType
     */

    public GuardrailPiiEntityFilter withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The PII entity filter type.
     * </p>
     * 
     * @param type
     *        The PII entity filter type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailPiiEntityType
     */

    public GuardrailPiiEntityFilter withType(GuardrailPiiEntityType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The PII entity filter action.
     * </p>
     * 
     * @param action
     *        The PII entity filter action.
     * @see GuardrailSensitiveInformationPolicyAction
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The PII entity filter action.
     * </p>
     * 
     * @return The PII entity filter action.
     * @see GuardrailSensitiveInformationPolicyAction
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The PII entity filter action.
     * </p>
     * 
     * @param action
     *        The PII entity filter action.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailSensitiveInformationPolicyAction
     */

    public GuardrailPiiEntityFilter withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The PII entity filter action.
     * </p>
     * 
     * @param action
     *        The PII entity filter action.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GuardrailSensitiveInformationPolicyAction
     */

    public GuardrailPiiEntityFilter withAction(GuardrailSensitiveInformationPolicyAction action) {
        this.action = action.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMatch() != null)
            sb.append("Match: ").append(getMatch()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getAction() != null)
            sb.append("Action: ").append(getAction());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GuardrailPiiEntityFilter == false)
            return false;
        GuardrailPiiEntityFilter other = (GuardrailPiiEntityFilter) obj;
        if (other.getMatch() == null ^ this.getMatch() == null)
            return false;
        if (other.getMatch() != null && other.getMatch().equals(this.getMatch()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMatch() == null) ? 0 : getMatch().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        return hashCode;
    }

    @Override
    public GuardrailPiiEntityFilter clone() {
        try {
            return (GuardrailPiiEntityFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockruntime.model.transform.GuardrailPiiEntityFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
