/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockruntime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The output content produced by the guardrail.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/GuardrailOutputContent"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GuardrailOutputContent implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The specific text for the output content produced by the guardrail.
     * </p>
     */
    private String text;

    /**
     * <p>
     * The specific text for the output content produced by the guardrail.
     * </p>
     * 
     * @param text
     *        The specific text for the output content produced by the guardrail.
     */

    public void setText(String text) {
        this.text = text;
    }

    /**
     * <p>
     * The specific text for the output content produced by the guardrail.
     * </p>
     * 
     * @return The specific text for the output content produced by the guardrail.
     */

    public String getText() {
        return this.text;
    }

    /**
     * <p>
     * The specific text for the output content produced by the guardrail.
     * </p>
     * 
     * @param text
     *        The specific text for the output content produced by the guardrail.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GuardrailOutputContent withText(String text) {
        setText(text);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getText() != null)
            sb.append("Text: ").append(getText());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GuardrailOutputContent == false)
            return false;
        GuardrailOutputContent other = (GuardrailOutputContent) obj;
        if (other.getText() == null ^ this.getText() == null)
            return false;
        if (other.getText() != null && other.getText().equals(this.getText()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getText() == null) ? 0 : getText().hashCode());
        return hashCode;
    }

    @Override
    public GuardrailOutputContent clone() {
        try {
            return (GuardrailOutputContent) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.bedrockruntime.model.transform.GuardrailOutputContentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
