/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.billingconductor;

import javax.annotation.Generated;

import com.amazonaws.services.billingconductor.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSBillingConductor}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSBillingConductor implements AWSBillingConductor {

    protected AbstractAWSBillingConductor() {
    }

    @Override
    public AssociateAccountsResult associateAccounts(AssociateAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociatePricingRulesResult associatePricingRules(AssociatePricingRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchAssociateResourcesToCustomLineItemResult batchAssociateResourcesToCustomLineItem(BatchAssociateResourcesToCustomLineItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDisassociateResourcesFromCustomLineItemResult batchDisassociateResourcesFromCustomLineItem(
            BatchDisassociateResourcesFromCustomLineItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBillingGroupResult createBillingGroup(CreateBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCustomLineItemResult createCustomLineItem(CreateCustomLineItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePricingPlanResult createPricingPlan(CreatePricingPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePricingRuleResult createPricingRule(CreatePricingRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBillingGroupResult deleteBillingGroup(DeleteBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomLineItemResult deleteCustomLineItem(DeleteCustomLineItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePricingPlanResult deletePricingPlan(DeletePricingPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePricingRuleResult deletePricingRule(DeletePricingRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateAccountsResult disassociateAccounts(DisassociateAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePricingRulesResult disassociatePricingRules(DisassociatePricingRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBillingGroupCostReportResult getBillingGroupCostReport(GetBillingGroupCostReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssociationsResult listAccountAssociations(ListAccountAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBillingGroupCostReportsResult listBillingGroupCostReports(ListBillingGroupCostReportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBillingGroupsResult listBillingGroups(ListBillingGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomLineItemVersionsResult listCustomLineItemVersions(ListCustomLineItemVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomLineItemsResult listCustomLineItems(ListCustomLineItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPricingPlansResult listPricingPlans(ListPricingPlansRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPricingPlansAssociatedWithPricingRuleResult listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPricingRulesResult listPricingRules(ListPricingRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPricingRulesAssociatedToPricingPlanResult listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourcesAssociatedToCustomLineItemResult listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBillingGroupResult updateBillingGroup(UpdateBillingGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCustomLineItemResult updateCustomLineItem(UpdateCustomLineItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePricingPlanResult updatePricingPlan(UpdatePricingPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePricingRuleResult updatePricingRule(UpdatePricingRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
