/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.budgets.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The historical records for a budget action.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ActionHistory implements Serializable, Cloneable, StructuredPojo {

    private java.util.Date timestamp;
    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     */
    private String status;
    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or are generated by the system.
     * </p>
     */
    private String eventType;
    /**
     * <p>
     * The description of the details for the event.
     * </p>
     */
    private ActionHistoryDetails actionHistoryDetails;

    /**
     * @param timestamp
     */

    public void setTimestamp(java.util.Date timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * @return
     */

    public java.util.Date getTimestamp() {
        return this.timestamp;
    }

    /**
     * @param timestamp
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ActionHistory withTimestamp(java.util.Date timestamp) {
        setTimestamp(timestamp);
        return this;
    }

    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     * 
     * @param status
     *        The status of action at the time of the event.
     * @see ActionStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     * 
     * @return The status of action at the time of the event.
     * @see ActionStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     * 
     * @param status
     *        The status of action at the time of the event.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ActionStatus
     */

    public ActionHistory withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of action at the time of the event.
     * </p>
     * 
     * @param status
     *        The status of action at the time of the event.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ActionStatus
     */

    public ActionHistory withStatus(ActionStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or are generated by the system.
     * </p>
     * 
     * @param eventType
     *        This distinguishes between whether the events are triggered by the user or are generated by the system.
     * @see EventType
     */

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or are generated by the system.
     * </p>
     * 
     * @return This distinguishes between whether the events are triggered by the user or are generated by the system.
     * @see EventType
     */

    public String getEventType() {
        return this.eventType;
    }

    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or are generated by the system.
     * </p>
     * 
     * @param eventType
     *        This distinguishes between whether the events are triggered by the user or are generated by the system.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EventType
     */

    public ActionHistory withEventType(String eventType) {
        setEventType(eventType);
        return this;
    }

    /**
     * <p>
     * This distinguishes between whether the events are triggered by the user or are generated by the system.
     * </p>
     * 
     * @param eventType
     *        This distinguishes between whether the events are triggered by the user or are generated by the system.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EventType
     */

    public ActionHistory withEventType(EventType eventType) {
        this.eventType = eventType.toString();
        return this;
    }

    /**
     * <p>
     * The description of the details for the event.
     * </p>
     * 
     * @param actionHistoryDetails
     *        The description of the details for the event.
     */

    public void setActionHistoryDetails(ActionHistoryDetails actionHistoryDetails) {
        this.actionHistoryDetails = actionHistoryDetails;
    }

    /**
     * <p>
     * The description of the details for the event.
     * </p>
     * 
     * @return The description of the details for the event.
     */

    public ActionHistoryDetails getActionHistoryDetails() {
        return this.actionHistoryDetails;
    }

    /**
     * <p>
     * The description of the details for the event.
     * </p>
     * 
     * @param actionHistoryDetails
     *        The description of the details for the event.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ActionHistory withActionHistoryDetails(ActionHistoryDetails actionHistoryDetails) {
        setActionHistoryDetails(actionHistoryDetails);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTimestamp() != null)
            sb.append("Timestamp: ").append(getTimestamp()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getEventType() != null)
            sb.append("EventType: ").append(getEventType()).append(",");
        if (getActionHistoryDetails() != null)
            sb.append("ActionHistoryDetails: ").append(getActionHistoryDetails());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ActionHistory == false)
            return false;
        ActionHistory other = (ActionHistory) obj;
        if (other.getTimestamp() == null ^ this.getTimestamp() == null)
            return false;
        if (other.getTimestamp() != null && other.getTimestamp().equals(this.getTimestamp()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getEventType() == null ^ this.getEventType() == null)
            return false;
        if (other.getEventType() != null && other.getEventType().equals(this.getEventType()) == false)
            return false;
        if (other.getActionHistoryDetails() == null ^ this.getActionHistoryDetails() == null)
            return false;
        if (other.getActionHistoryDetails() != null && other.getActionHistoryDetails().equals(this.getActionHistoryDetails()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTimestamp() == null) ? 0 : getTimestamp().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getEventType() == null) ? 0 : getEventType().hashCode());
        hashCode = prime * hashCode + ((getActionHistoryDetails() == null) ? 0 : getActionHistoryDetails().hashCode());
        return hashCode;
    }

    @Override
    public ActionHistory clone() {
        try {
            return (ActionHistory) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.budgets.model.transform.ActionHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
