/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty;

import javax.annotation.Generated;

import com.amazonaws.services.guardduty.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonGuardDuty}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonGuardDuty implements AmazonGuardDuty {

    protected AbstractAmazonGuardDuty() {
    }

    @Override
    public AcceptInvitationResult acceptInvitation(AcceptInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ArchiveFindingsResult archiveFindings(ArchiveFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDetectorResult createDetector(CreateDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFilterResult createFilter(CreateFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIPSetResult createIPSet(CreateIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMembersResult createMembers(CreateMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePublishingDestinationResult createPublishingDestination(CreatePublishingDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSampleFindingsResult createSampleFindings(CreateSampleFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateThreatIntelSetResult createThreatIntelSet(CreateThreatIntelSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeclineInvitationsResult declineInvitations(DeclineInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDetectorResult deleteDetector(DeleteDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFilterResult deleteFilter(DeleteFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIPSetResult deleteIPSet(DeleteIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInvitationsResult deleteInvitations(DeleteInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMembersResult deleteMembers(DeleteMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePublishingDestinationResult deletePublishingDestination(DeletePublishingDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteThreatIntelSetResult deleteThreatIntelSet(DeleteThreatIntelSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationConfigurationResult describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePublishingDestinationResult describePublishingDestination(DescribePublishingDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableOrganizationAdminAccountResult disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateFromMasterAccountResult disassociateFromMasterAccount(DisassociateFromMasterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMembersResult disassociateMembers(DisassociateMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableOrganizationAdminAccountResult enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDetectorResult getDetector(GetDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFilterResult getFilter(GetFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsResult getFindings(GetFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsStatisticsResult getFindingsStatistics(GetFindingsStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIPSetResult getIPSet(GetIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInvitationsCountResult getInvitationsCount(GetInvitationsCountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMasterAccountResult getMasterAccount(GetMasterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMemberDetectorsResult getMemberDetectors(GetMemberDetectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMembersResult getMembers(GetMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetThreatIntelSetResult getThreatIntelSet(GetThreatIntelSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUsageStatisticsResult getUsageStatistics(GetUsageStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InviteMembersResult inviteMembers(InviteMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDetectorsResult listDetectors(ListDetectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFiltersResult listFilters(ListFiltersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingsResult listFindings(ListFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIPSetsResult listIPSets(ListIPSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrganizationAdminAccountsResult listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPublishingDestinationsResult listPublishingDestinations(ListPublishingDestinationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListThreatIntelSetsResult listThreatIntelSets(ListThreatIntelSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMonitoringMembersResult startMonitoringMembers(StartMonitoringMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopMonitoringMembersResult stopMonitoringMembers(StopMonitoringMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UnarchiveFindingsResult unarchiveFindings(UnarchiveFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDetectorResult updateDetector(UpdateDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFilterResult updateFilter(UpdateFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFindingsFeedbackResult updateFindingsFeedback(UpdateFindingsFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIPSetResult updateIPSet(UpdateIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMemberDetectorsResult updateMemberDetectors(UpdateMemberDetectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOrganizationConfigurationResult updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePublishingDestinationResult updatePublishingDestination(UpdatePublishingDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThreatIntelSetResult updateThreatIntelSet(UpdateThreatIntelSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
