/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecommerceanalytics;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.marketplacecommerceanalytics.AWSMarketplaceCommerceAnalyticsAsync;
import com.amazonaws.services.marketplacecommerceanalytics.AWSMarketplaceCommerceAnalyticsAsyncClientBuilder;
import com.amazonaws.services.marketplacecommerceanalytics.AWSMarketplaceCommerceAnalyticsClient;
import com.amazonaws.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;
import com.amazonaws.services.marketplacecommerceanalytics.model.GenerateDataSetResult;
import com.amazonaws.services.marketplacecommerceanalytics.model.StartSupportDataExportRequest;
import com.amazonaws.services.marketplacecommerceanalytics.model.StartSupportDataExportResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMarketplaceCommerceAnalyticsAsyncClient
extends AWSMarketplaceCommerceAnalyticsClient
implements AWSMarketplaceCommerceAnalyticsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSMarketplaceCommerceAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSMarketplaceCommerceAnalyticsAsyncClientBuilder asyncBuilder() {
        return AWSMarketplaceCommerceAnalyticsAsyncClientBuilder.standard();
    }

    AWSMarketplaceCommerceAnalyticsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GenerateDataSetResult> generateDataSetAsync(GenerateDataSetRequest request) {
        return this.generateDataSetAsync(request, null);
    }

    @Override
    public Future<GenerateDataSetResult> generateDataSetAsync(final GenerateDataSetRequest request, final AsyncHandler<GenerateDataSetRequest, GenerateDataSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GenerateDataSetResult>(){

            @Override
            public GenerateDataSetResult call() throws Exception {
                GenerateDataSetResult result;
                try {
                    result = AWSMarketplaceCommerceAnalyticsAsyncClient.this.generateDataSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSupportDataExportResult> startSupportDataExportAsync(StartSupportDataExportRequest request) {
        return this.startSupportDataExportAsync(request, null);
    }

    @Override
    public Future<StartSupportDataExportResult> startSupportDataExportAsync(final StartSupportDataExportRequest request, final AsyncHandler<StartSupportDataExportRequest, StartSupportDataExportResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartSupportDataExportResult>(){

            @Override
            public StartSupportDataExportResult call() throws Exception {
                StartSupportDataExportResult result;
                try {
                    result = AWSMarketplaceCommerceAnalyticsAsyncClient.this.startSupportDataExport(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

