/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.applicationdiscovery.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeAgentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> agentIds;
    private List<Filter> filters;
    private Integer maxResults;
    private String nextToken;

    public List<String> getAgentIds() {
        return this.agentIds;
    }

    public void setAgentIds(Collection<String> agentIds) {
        if (agentIds == null) {
            this.agentIds = null;
            return;
        }
        this.agentIds = new ArrayList<String>(agentIds);
    }

    public DescribeAgentsRequest withAgentIds(String ... agentIds) {
        if (this.agentIds == null) {
            this.setAgentIds(new ArrayList<String>(agentIds.length));
        }
        for (String ele : agentIds) {
            this.agentIds.add(ele);
        }
        return this;
    }

    public DescribeAgentsRequest withAgentIds(Collection<String> agentIds) {
        this.setAgentIds(agentIds);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public DescribeAgentsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeAgentsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeAgentsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeAgentsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAgentIds() != null) {
            sb.append("AgentIds: ").append(this.getAgentIds()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentsRequest)) {
            return false;
        }
        DescribeAgentsRequest other = (DescribeAgentsRequest)obj;
        if (other.getAgentIds() == null ^ this.getAgentIds() == null) {
            return false;
        }
        if (other.getAgentIds() != null && !other.getAgentIds().equals(this.getAgentIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAgentIds() == null ? 0 : this.getAgentIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAgentsRequest clone() {
        return (DescribeAgentsRequest)super.clone();
    }
}

