/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrass;

import javax.annotation.Generated;

import com.amazonaws.services.greengrass.model.*;

/**
 * Abstract implementation of {@code AWSGreengrassAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGreengrassAsync extends AbstractAWSGreengrass implements AWSGreengrassAsync {

    protected AbstractAWSGreengrassAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateRoleToGroupResult> associateRoleToGroupAsync(AssociateRoleToGroupRequest request) {

        return associateRoleToGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateRoleToGroupResult> associateRoleToGroupAsync(AssociateRoleToGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateRoleToGroupRequest, AssociateRoleToGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateServiceRoleToAccountResult> associateServiceRoleToAccountAsync(AssociateServiceRoleToAccountRequest request) {

        return associateServiceRoleToAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateServiceRoleToAccountResult> associateServiceRoleToAccountAsync(AssociateServiceRoleToAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateServiceRoleToAccountRequest, AssociateServiceRoleToAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCoreDefinitionResult> createCoreDefinitionAsync(CreateCoreDefinitionRequest request) {

        return createCoreDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCoreDefinitionResult> createCoreDefinitionAsync(CreateCoreDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCoreDefinitionRequest, CreateCoreDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCoreDefinitionVersionResult> createCoreDefinitionVersionAsync(CreateCoreDefinitionVersionRequest request) {

        return createCoreDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCoreDefinitionVersionResult> createCoreDefinitionVersionAsync(CreateCoreDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCoreDefinitionVersionRequest, CreateCoreDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request) {

        return createDeploymentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDeploymentRequest, CreateDeploymentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDeviceDefinitionResult> createDeviceDefinitionAsync(CreateDeviceDefinitionRequest request) {

        return createDeviceDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDeviceDefinitionResult> createDeviceDefinitionAsync(CreateDeviceDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDeviceDefinitionRequest, CreateDeviceDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDeviceDefinitionVersionResult> createDeviceDefinitionVersionAsync(CreateDeviceDefinitionVersionRequest request) {

        return createDeviceDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDeviceDefinitionVersionResult> createDeviceDefinitionVersionAsync(CreateDeviceDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDeviceDefinitionVersionRequest, CreateDeviceDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFunctionDefinitionResult> createFunctionDefinitionAsync(CreateFunctionDefinitionRequest request) {

        return createFunctionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFunctionDefinitionResult> createFunctionDefinitionAsync(CreateFunctionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFunctionDefinitionRequest, CreateFunctionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFunctionDefinitionVersionResult> createFunctionDefinitionVersionAsync(
            CreateFunctionDefinitionVersionRequest request) {

        return createFunctionDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFunctionDefinitionVersionResult> createFunctionDefinitionVersionAsync(
            CreateFunctionDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFunctionDefinitionVersionRequest, CreateFunctionDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request) {

        return createGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGroupRequest, CreateGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGroupCertificateAuthorityResult> createGroupCertificateAuthorityAsync(
            CreateGroupCertificateAuthorityRequest request) {

        return createGroupCertificateAuthorityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGroupCertificateAuthorityResult> createGroupCertificateAuthorityAsync(
            CreateGroupCertificateAuthorityRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGroupCertificateAuthorityRequest, CreateGroupCertificateAuthorityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGroupVersionResult> createGroupVersionAsync(CreateGroupVersionRequest request) {

        return createGroupVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGroupVersionResult> createGroupVersionAsync(CreateGroupVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGroupVersionRequest, CreateGroupVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLoggerDefinitionResult> createLoggerDefinitionAsync(CreateLoggerDefinitionRequest request) {

        return createLoggerDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLoggerDefinitionResult> createLoggerDefinitionAsync(CreateLoggerDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLoggerDefinitionRequest, CreateLoggerDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLoggerDefinitionVersionResult> createLoggerDefinitionVersionAsync(CreateLoggerDefinitionVersionRequest request) {

        return createLoggerDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLoggerDefinitionVersionResult> createLoggerDefinitionVersionAsync(CreateLoggerDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLoggerDefinitionVersionRequest, CreateLoggerDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionDefinitionResult> createSubscriptionDefinitionAsync(CreateSubscriptionDefinitionRequest request) {

        return createSubscriptionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionDefinitionResult> createSubscriptionDefinitionAsync(CreateSubscriptionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSubscriptionDefinitionRequest, CreateSubscriptionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionDefinitionVersionResult> createSubscriptionDefinitionVersionAsync(
            CreateSubscriptionDefinitionVersionRequest request) {

        return createSubscriptionDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionDefinitionVersionResult> createSubscriptionDefinitionVersionAsync(
            CreateSubscriptionDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSubscriptionDefinitionVersionRequest, CreateSubscriptionDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCoreDefinitionResult> deleteCoreDefinitionAsync(DeleteCoreDefinitionRequest request) {

        return deleteCoreDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCoreDefinitionResult> deleteCoreDefinitionAsync(DeleteCoreDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCoreDefinitionRequest, DeleteCoreDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDeviceDefinitionResult> deleteDeviceDefinitionAsync(DeleteDeviceDefinitionRequest request) {

        return deleteDeviceDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDeviceDefinitionResult> deleteDeviceDefinitionAsync(DeleteDeviceDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDeviceDefinitionRequest, DeleteDeviceDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFunctionDefinitionResult> deleteFunctionDefinitionAsync(DeleteFunctionDefinitionRequest request) {

        return deleteFunctionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFunctionDefinitionResult> deleteFunctionDefinitionAsync(DeleteFunctionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFunctionDefinitionRequest, DeleteFunctionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {

        return deleteGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLoggerDefinitionResult> deleteLoggerDefinitionAsync(DeleteLoggerDefinitionRequest request) {

        return deleteLoggerDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLoggerDefinitionResult> deleteLoggerDefinitionAsync(DeleteLoggerDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLoggerDefinitionRequest, DeleteLoggerDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionDefinitionResult> deleteSubscriptionDefinitionAsync(DeleteSubscriptionDefinitionRequest request) {

        return deleteSubscriptionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionDefinitionResult> deleteSubscriptionDefinitionAsync(DeleteSubscriptionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSubscriptionDefinitionRequest, DeleteSubscriptionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateRoleFromGroupResult> disassociateRoleFromGroupAsync(DisassociateRoleFromGroupRequest request) {

        return disassociateRoleFromGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateRoleFromGroupResult> disassociateRoleFromGroupAsync(DisassociateRoleFromGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateRoleFromGroupRequest, DisassociateRoleFromGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateServiceRoleFromAccountResult> disassociateServiceRoleFromAccountAsync(
            DisassociateServiceRoleFromAccountRequest request) {

        return disassociateServiceRoleFromAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateServiceRoleFromAccountResult> disassociateServiceRoleFromAccountAsync(
            DisassociateServiceRoleFromAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateServiceRoleFromAccountRequest, DisassociateServiceRoleFromAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssociatedRoleResult> getAssociatedRoleAsync(GetAssociatedRoleRequest request) {

        return getAssociatedRoleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssociatedRoleResult> getAssociatedRoleAsync(GetAssociatedRoleRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssociatedRoleRequest, GetAssociatedRoleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConnectivityInfoResult> getConnectivityInfoAsync(GetConnectivityInfoRequest request) {

        return getConnectivityInfoAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConnectivityInfoResult> getConnectivityInfoAsync(GetConnectivityInfoRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConnectivityInfoRequest, GetConnectivityInfoResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCoreDefinitionResult> getCoreDefinitionAsync(GetCoreDefinitionRequest request) {

        return getCoreDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCoreDefinitionResult> getCoreDefinitionAsync(GetCoreDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCoreDefinitionRequest, GetCoreDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCoreDefinitionVersionResult> getCoreDefinitionVersionAsync(GetCoreDefinitionVersionRequest request) {

        return getCoreDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCoreDefinitionVersionResult> getCoreDefinitionVersionAsync(GetCoreDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCoreDefinitionVersionRequest, GetCoreDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDeploymentStatusResult> getDeploymentStatusAsync(GetDeploymentStatusRequest request) {

        return getDeploymentStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDeploymentStatusResult> getDeploymentStatusAsync(GetDeploymentStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDeploymentStatusRequest, GetDeploymentStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDeviceDefinitionResult> getDeviceDefinitionAsync(GetDeviceDefinitionRequest request) {

        return getDeviceDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDeviceDefinitionResult> getDeviceDefinitionAsync(GetDeviceDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDeviceDefinitionRequest, GetDeviceDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDeviceDefinitionVersionResult> getDeviceDefinitionVersionAsync(GetDeviceDefinitionVersionRequest request) {

        return getDeviceDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDeviceDefinitionVersionResult> getDeviceDefinitionVersionAsync(GetDeviceDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDeviceDefinitionVersionRequest, GetDeviceDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFunctionDefinitionResult> getFunctionDefinitionAsync(GetFunctionDefinitionRequest request) {

        return getFunctionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFunctionDefinitionResult> getFunctionDefinitionAsync(GetFunctionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFunctionDefinitionRequest, GetFunctionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFunctionDefinitionVersionResult> getFunctionDefinitionVersionAsync(GetFunctionDefinitionVersionRequest request) {

        return getFunctionDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFunctionDefinitionVersionResult> getFunctionDefinitionVersionAsync(GetFunctionDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFunctionDefinitionVersionRequest, GetFunctionDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGroupResult> getGroupAsync(GetGroupRequest request) {

        return getGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGroupResult> getGroupAsync(GetGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGroupRequest, GetGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGroupCertificateAuthorityResult> getGroupCertificateAuthorityAsync(GetGroupCertificateAuthorityRequest request) {

        return getGroupCertificateAuthorityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGroupCertificateAuthorityResult> getGroupCertificateAuthorityAsync(GetGroupCertificateAuthorityRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGroupCertificateAuthorityRequest, GetGroupCertificateAuthorityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGroupCertificateConfigurationResult> getGroupCertificateConfigurationAsync(
            GetGroupCertificateConfigurationRequest request) {

        return getGroupCertificateConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGroupCertificateConfigurationResult> getGroupCertificateConfigurationAsync(
            GetGroupCertificateConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGroupCertificateConfigurationRequest, GetGroupCertificateConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGroupVersionResult> getGroupVersionAsync(GetGroupVersionRequest request) {

        return getGroupVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGroupVersionResult> getGroupVersionAsync(GetGroupVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGroupVersionRequest, GetGroupVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLoggerDefinitionResult> getLoggerDefinitionAsync(GetLoggerDefinitionRequest request) {

        return getLoggerDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLoggerDefinitionResult> getLoggerDefinitionAsync(GetLoggerDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLoggerDefinitionRequest, GetLoggerDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLoggerDefinitionVersionResult> getLoggerDefinitionVersionAsync(GetLoggerDefinitionVersionRequest request) {

        return getLoggerDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLoggerDefinitionVersionResult> getLoggerDefinitionVersionAsync(GetLoggerDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLoggerDefinitionVersionRequest, GetLoggerDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceRoleForAccountResult> getServiceRoleForAccountAsync(GetServiceRoleForAccountRequest request) {

        return getServiceRoleForAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceRoleForAccountResult> getServiceRoleForAccountAsync(GetServiceRoleForAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceRoleForAccountRequest, GetServiceRoleForAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionDefinitionResult> getSubscriptionDefinitionAsync(GetSubscriptionDefinitionRequest request) {

        return getSubscriptionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionDefinitionResult> getSubscriptionDefinitionAsync(GetSubscriptionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubscriptionDefinitionRequest, GetSubscriptionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionDefinitionVersionResult> getSubscriptionDefinitionVersionAsync(
            GetSubscriptionDefinitionVersionRequest request) {

        return getSubscriptionDefinitionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionDefinitionVersionResult> getSubscriptionDefinitionVersionAsync(
            GetSubscriptionDefinitionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubscriptionDefinitionVersionRequest, GetSubscriptionDefinitionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCoreDefinitionVersionsResult> listCoreDefinitionVersionsAsync(ListCoreDefinitionVersionsRequest request) {

        return listCoreDefinitionVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCoreDefinitionVersionsResult> listCoreDefinitionVersionsAsync(ListCoreDefinitionVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCoreDefinitionVersionsRequest, ListCoreDefinitionVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCoreDefinitionsResult> listCoreDefinitionsAsync(ListCoreDefinitionsRequest request) {

        return listCoreDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCoreDefinitionsResult> listCoreDefinitionsAsync(ListCoreDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCoreDefinitionsRequest, ListCoreDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request) {

        return listDeploymentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDeploymentsRequest, ListDeploymentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDeviceDefinitionVersionsResult> listDeviceDefinitionVersionsAsync(ListDeviceDefinitionVersionsRequest request) {

        return listDeviceDefinitionVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDeviceDefinitionVersionsResult> listDeviceDefinitionVersionsAsync(ListDeviceDefinitionVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDeviceDefinitionVersionsRequest, ListDeviceDefinitionVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDeviceDefinitionsResult> listDeviceDefinitionsAsync(ListDeviceDefinitionsRequest request) {

        return listDeviceDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDeviceDefinitionsResult> listDeviceDefinitionsAsync(ListDeviceDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDeviceDefinitionsRequest, ListDeviceDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFunctionDefinitionVersionsResult> listFunctionDefinitionVersionsAsync(ListFunctionDefinitionVersionsRequest request) {

        return listFunctionDefinitionVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFunctionDefinitionVersionsResult> listFunctionDefinitionVersionsAsync(ListFunctionDefinitionVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFunctionDefinitionVersionsRequest, ListFunctionDefinitionVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFunctionDefinitionsResult> listFunctionDefinitionsAsync(ListFunctionDefinitionsRequest request) {

        return listFunctionDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFunctionDefinitionsResult> listFunctionDefinitionsAsync(ListFunctionDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFunctionDefinitionsRequest, ListFunctionDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGroupCertificateAuthoritiesResult> listGroupCertificateAuthoritiesAsync(
            ListGroupCertificateAuthoritiesRequest request) {

        return listGroupCertificateAuthoritiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGroupCertificateAuthoritiesResult> listGroupCertificateAuthoritiesAsync(
            ListGroupCertificateAuthoritiesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGroupCertificateAuthoritiesRequest, ListGroupCertificateAuthoritiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGroupVersionsResult> listGroupVersionsAsync(ListGroupVersionsRequest request) {

        return listGroupVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGroupVersionsResult> listGroupVersionsAsync(ListGroupVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGroupVersionsRequest, ListGroupVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {

        return listGroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLoggerDefinitionVersionsResult> listLoggerDefinitionVersionsAsync(ListLoggerDefinitionVersionsRequest request) {

        return listLoggerDefinitionVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLoggerDefinitionVersionsResult> listLoggerDefinitionVersionsAsync(ListLoggerDefinitionVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLoggerDefinitionVersionsRequest, ListLoggerDefinitionVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLoggerDefinitionsResult> listLoggerDefinitionsAsync(ListLoggerDefinitionsRequest request) {

        return listLoggerDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLoggerDefinitionsResult> listLoggerDefinitionsAsync(ListLoggerDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLoggerDefinitionsRequest, ListLoggerDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionDefinitionVersionsResult> listSubscriptionDefinitionVersionsAsync(
            ListSubscriptionDefinitionVersionsRequest request) {

        return listSubscriptionDefinitionVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionDefinitionVersionsResult> listSubscriptionDefinitionVersionsAsync(
            ListSubscriptionDefinitionVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubscriptionDefinitionVersionsRequest, ListSubscriptionDefinitionVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionDefinitionsResult> listSubscriptionDefinitionsAsync(ListSubscriptionDefinitionsRequest request) {

        return listSubscriptionDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionDefinitionsResult> listSubscriptionDefinitionsAsync(ListSubscriptionDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubscriptionDefinitionsRequest, ListSubscriptionDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateConnectivityInfoResult> updateConnectivityInfoAsync(UpdateConnectivityInfoRequest request) {

        return updateConnectivityInfoAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateConnectivityInfoResult> updateConnectivityInfoAsync(UpdateConnectivityInfoRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateConnectivityInfoRequest, UpdateConnectivityInfoResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateCoreDefinitionResult> updateCoreDefinitionAsync(UpdateCoreDefinitionRequest request) {

        return updateCoreDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateCoreDefinitionResult> updateCoreDefinitionAsync(UpdateCoreDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateCoreDefinitionRequest, UpdateCoreDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDeviceDefinitionResult> updateDeviceDefinitionAsync(UpdateDeviceDefinitionRequest request) {

        return updateDeviceDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDeviceDefinitionResult> updateDeviceDefinitionAsync(UpdateDeviceDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDeviceDefinitionRequest, UpdateDeviceDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateFunctionDefinitionResult> updateFunctionDefinitionAsync(UpdateFunctionDefinitionRequest request) {

        return updateFunctionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateFunctionDefinitionResult> updateFunctionDefinitionAsync(UpdateFunctionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateFunctionDefinitionRequest, UpdateFunctionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request) {

        return updateGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGroupRequest, UpdateGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGroupCertificateConfigurationResult> updateGroupCertificateConfigurationAsync(
            UpdateGroupCertificateConfigurationRequest request) {

        return updateGroupCertificateConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGroupCertificateConfigurationResult> updateGroupCertificateConfigurationAsync(
            UpdateGroupCertificateConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGroupCertificateConfigurationRequest, UpdateGroupCertificateConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateLoggerDefinitionResult> updateLoggerDefinitionAsync(UpdateLoggerDefinitionRequest request) {

        return updateLoggerDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateLoggerDefinitionResult> updateLoggerDefinitionAsync(UpdateLoggerDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateLoggerDefinitionRequest, UpdateLoggerDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionDefinitionResult> updateSubscriptionDefinitionAsync(UpdateSubscriptionDefinitionRequest request) {

        return updateSubscriptionDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionDefinitionResult> updateSubscriptionDefinitionAsync(UpdateSubscriptionDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSubscriptionDefinitionRequest, UpdateSubscriptionDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
