/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.transform.ResourceRecordSetStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ChangeStaxUnmarshaller
implements Unmarshaller<Change, StaxUnmarshallerContext> {
    private static ChangeStaxUnmarshaller instance;

    @Override
    public Change unmarshall(StaxUnmarshallerContext context) throws Exception {
        Change change = new Change();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return change;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Action", targetDepth)) {
                    change.setAction(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceRecordSet", targetDepth)) continue;
                change.setResourceRecordSet(ResourceRecordSetStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return change;
    }

    public static ChangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ChangeStaxUnmarshaller();
        }
        return instance;
    }
}

