/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.directory.model.RadiusAuthenticationProtocol;
import com.amazonaws.services.directory.model.transform.RadiusSettingsMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RadiusSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalList<String> radiusServers;
    private Integer radiusPort;
    private Integer radiusTimeout;
    private Integer radiusRetries;
    private String sharedSecret;
    private String authenticationProtocol;
    private String displayLabel;
    private Boolean useSameUsername;

    public List<String> getRadiusServers() {
        if (this.radiusServers == null) {
            this.radiusServers = new SdkInternalList();
        }
        return this.radiusServers;
    }

    public void setRadiusServers(Collection<String> radiusServers) {
        if (radiusServers == null) {
            this.radiusServers = null;
            return;
        }
        this.radiusServers = new SdkInternalList<String>(radiusServers);
    }

    public RadiusSettings withRadiusServers(String ... radiusServers) {
        if (this.radiusServers == null) {
            this.setRadiusServers(new SdkInternalList<String>(radiusServers.length));
        }
        for (String ele : radiusServers) {
            this.radiusServers.add(ele);
        }
        return this;
    }

    public RadiusSettings withRadiusServers(Collection<String> radiusServers) {
        this.setRadiusServers(radiusServers);
        return this;
    }

    public void setRadiusPort(Integer radiusPort) {
        this.radiusPort = radiusPort;
    }

    public Integer getRadiusPort() {
        return this.radiusPort;
    }

    public RadiusSettings withRadiusPort(Integer radiusPort) {
        this.setRadiusPort(radiusPort);
        return this;
    }

    public void setRadiusTimeout(Integer radiusTimeout) {
        this.radiusTimeout = radiusTimeout;
    }

    public Integer getRadiusTimeout() {
        return this.radiusTimeout;
    }

    public RadiusSettings withRadiusTimeout(Integer radiusTimeout) {
        this.setRadiusTimeout(radiusTimeout);
        return this;
    }

    public void setRadiusRetries(Integer radiusRetries) {
        this.radiusRetries = radiusRetries;
    }

    public Integer getRadiusRetries() {
        return this.radiusRetries;
    }

    public RadiusSettings withRadiusRetries(Integer radiusRetries) {
        this.setRadiusRetries(radiusRetries);
        return this;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public RadiusSettings withSharedSecret(String sharedSecret) {
        this.setSharedSecret(sharedSecret);
        return this;
    }

    public void setAuthenticationProtocol(String authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    @JsonProperty(value="authenticationProtocol")
    public String getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public RadiusSettings withAuthenticationProtocol(String authenticationProtocol) {
        this.setAuthenticationProtocol(authenticationProtocol);
        return this;
    }

    @JsonIgnore
    public void setAuthenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol) {
        this.withAuthenticationProtocol(authenticationProtocol);
    }

    public RadiusSettings withAuthenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol.toString();
        return this;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public RadiusSettings withDisplayLabel(String displayLabel) {
        this.setDisplayLabel(displayLabel);
        return this;
    }

    public void setUseSameUsername(Boolean useSameUsername) {
        this.useSameUsername = useSameUsername;
    }

    public Boolean getUseSameUsername() {
        return this.useSameUsername;
    }

    public RadiusSettings withUseSameUsername(Boolean useSameUsername) {
        this.setUseSameUsername(useSameUsername);
        return this;
    }

    public Boolean isUseSameUsername() {
        return this.useSameUsername;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRadiusServers() != null) {
            sb.append("RadiusServers: ").append(this.getRadiusServers()).append(",");
        }
        if (this.getRadiusPort() != null) {
            sb.append("RadiusPort: ").append(this.getRadiusPort()).append(",");
        }
        if (this.getRadiusTimeout() != null) {
            sb.append("RadiusTimeout: ").append(this.getRadiusTimeout()).append(",");
        }
        if (this.getRadiusRetries() != null) {
            sb.append("RadiusRetries: ").append(this.getRadiusRetries()).append(",");
        }
        if (this.getSharedSecret() != null) {
            sb.append("SharedSecret: ").append(this.getSharedSecret()).append(",");
        }
        if (this.getAuthenticationProtocol() != null) {
            sb.append("AuthenticationProtocol: ").append(this.getAuthenticationProtocol()).append(",");
        }
        if (this.getDisplayLabel() != null) {
            sb.append("DisplayLabel: ").append(this.getDisplayLabel()).append(",");
        }
        if (this.getUseSameUsername() != null) {
            sb.append("UseSameUsername: ").append(this.getUseSameUsername());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadiusSettings)) {
            return false;
        }
        RadiusSettings other = (RadiusSettings)obj;
        if (other.getRadiusServers() == null ^ this.getRadiusServers() == null) {
            return false;
        }
        if (other.getRadiusServers() != null && !other.getRadiusServers().equals(this.getRadiusServers())) {
            return false;
        }
        if (other.getRadiusPort() == null ^ this.getRadiusPort() == null) {
            return false;
        }
        if (other.getRadiusPort() != null && !other.getRadiusPort().equals(this.getRadiusPort())) {
            return false;
        }
        if (other.getRadiusTimeout() == null ^ this.getRadiusTimeout() == null) {
            return false;
        }
        if (other.getRadiusTimeout() != null && !other.getRadiusTimeout().equals(this.getRadiusTimeout())) {
            return false;
        }
        if (other.getRadiusRetries() == null ^ this.getRadiusRetries() == null) {
            return false;
        }
        if (other.getRadiusRetries() != null && !other.getRadiusRetries().equals(this.getRadiusRetries())) {
            return false;
        }
        if (other.getSharedSecret() == null ^ this.getSharedSecret() == null) {
            return false;
        }
        if (other.getSharedSecret() != null && !other.getSharedSecret().equals(this.getSharedSecret())) {
            return false;
        }
        if (other.getAuthenticationProtocol() == null ^ this.getAuthenticationProtocol() == null) {
            return false;
        }
        if (other.getAuthenticationProtocol() != null && !other.getAuthenticationProtocol().equals(this.getAuthenticationProtocol())) {
            return false;
        }
        if (other.getDisplayLabel() == null ^ this.getDisplayLabel() == null) {
            return false;
        }
        if (other.getDisplayLabel() != null && !other.getDisplayLabel().equals(this.getDisplayLabel())) {
            return false;
        }
        if (other.getUseSameUsername() == null ^ this.getUseSameUsername() == null) {
            return false;
        }
        return other.getUseSameUsername() == null || other.getUseSameUsername().equals(this.getUseSameUsername());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRadiusServers() == null ? 0 : this.getRadiusServers().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusPort() == null ? 0 : this.getRadiusPort().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusTimeout() == null ? 0 : this.getRadiusTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusRetries() == null ? 0 : this.getRadiusRetries().hashCode());
        hashCode = 31 * hashCode + (this.getSharedSecret() == null ? 0 : this.getSharedSecret().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationProtocol() == null ? 0 : this.getAuthenticationProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayLabel() == null ? 0 : this.getDisplayLabel().hashCode());
        hashCode = 31 * hashCode + (this.getUseSameUsername() == null ? 0 : this.getUseSameUsername().hashCode());
        return hashCode;
    }

    public RadiusSettings clone() {
        try {
            return (RadiusSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RadiusSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

