/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeAsync;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeAsyncClientBuilder;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeClient;
import com.amazonaws.services.lexruntime.model.PostContentRequest;
import com.amazonaws.services.lexruntime.model.PostContentResult;
import com.amazonaws.services.lexruntime.model.PostTextRequest;
import com.amazonaws.services.lexruntime.model.PostTextResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonLexRuntimeAsyncClient
extends AmazonLexRuntimeClient
implements AmazonLexRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonLexRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonLexRuntimeAsyncClientBuilder.standard();
    }

    AmazonLexRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<PostContentResult> postContentAsync(PostContentRequest request) {
        return this.postContentAsync(request, null);
    }

    @Override
    public Future<PostContentResult> postContentAsync(PostContentRequest request, final AsyncHandler<PostContentRequest, PostContentResult> asyncHandler) {
        final PostContentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PostContentResult>(){

            @Override
            public PostContentResult call() throws Exception {
                PostContentResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executePostContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PostTextResult> postTextAsync(PostTextRequest request) {
        return this.postTextAsync(request, null);
    }

    @Override
    public Future<PostTextResult> postTextAsync(PostTextRequest request, final AsyncHandler<PostTextRequest, PostTextResult> asyncHandler) {
        final PostTextRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PostTextResult>(){

            @Override
            public PostTextResult call() throws Exception {
                PostTextResult result = null;
                try {
                    result = AmazonLexRuntimeAsyncClient.this.executePostText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

