/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Action;
import com.amazonaws.services.pinpoint.model.transform.DefaultPushNotificationMessageMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPushNotificationMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String action;
    private String body;
    private Map<String, String> data;
    private Boolean silentPush;
    private Map<String, List<String>> substitutions;
    private String title;
    private String url;

    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public DefaultPushNotificationMessage withAction(String action) {
        this.setAction(action);
        return this;
    }

    @JsonIgnore
    public void setAction(Action action) {
        this.withAction(action);
    }

    public DefaultPushNotificationMessage withAction(Action action) {
        this.action = action.toString();
        return this;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public DefaultPushNotificationMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public DefaultPushNotificationMessage withData(Map<String, String> data) {
        this.setData(data);
        return this;
    }

    public DefaultPushNotificationMessage addDataEntry(String key, String value) {
        if (null == this.data) {
            this.data = new HashMap<String, String>();
        }
        if (this.data.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.data.put(key, value);
        return this;
    }

    public DefaultPushNotificationMessage clearDataEntries() {
        this.data = null;
        return this;
    }

    public void setSilentPush(Boolean silentPush) {
        this.silentPush = silentPush;
    }

    public Boolean getSilentPush() {
        return this.silentPush;
    }

    public DefaultPushNotificationMessage withSilentPush(Boolean silentPush) {
        this.setSilentPush(silentPush);
        return this;
    }

    public Boolean isSilentPush() {
        return this.silentPush;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public DefaultPushNotificationMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public DefaultPushNotificationMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public DefaultPushNotificationMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public DefaultPushNotificationMessage withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public DefaultPushNotificationMessage withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getSilentPush() != null) {
            sb.append("SilentPush: ").append(this.getSilentPush()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPushNotificationMessage)) {
            return false;
        }
        DefaultPushNotificationMessage other = (DefaultPushNotificationMessage)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getSilentPush() == null ^ this.getSilentPush() == null) {
            return false;
        }
        if (other.getSilentPush() != null && !other.getSilentPush().equals(this.getSilentPush())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        if (other.getSubstitutions() != null && !other.getSubstitutions().equals(this.getSubstitutions())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        return other.getUrl() == null || other.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getSilentPush() == null ? 0 : this.getSilentPush().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        return hashCode;
    }

    public DefaultPushNotificationMessage clone() {
        try {
            return (DefaultPushNotificationMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefaultPushNotificationMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

