/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.CommandStatus;
import com.amazonaws.services.simplesystemsmanagement.model.NotificationConfig;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CommandMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Command
implements Serializable,
Cloneable,
StructuredPojo {
    private String commandId;
    private String documentName;
    private String comment;
    private Date expiresAfter;
    private Map<String, List<String>> parameters;
    private SdkInternalList<String> instanceIds;
    private SdkInternalList<Target> targets;
    private Date requestedDateTime;
    private String status;
    private String statusDetails;
    private String outputS3Region;
    private String outputS3BucketName;
    private String outputS3KeyPrefix;
    private String maxConcurrency;
    private String maxErrors;
    private Integer targetCount;
    private Integer completedCount;
    private Integer errorCount;
    private String serviceRole;
    private NotificationConfig notificationConfig;

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public Command withCommandId(String commandId) {
        this.setCommandId(commandId);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public Command withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public Command withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public void setExpiresAfter(Date expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public Date getExpiresAfter() {
        return this.expiresAfter;
    }

    public Command withExpiresAfter(Date expiresAfter) {
        this.setExpiresAfter(expiresAfter);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public Command withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Command addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public Command clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new SdkInternalList();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new SdkInternalList<String>(instanceIds);
    }

    public Command withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds(new SdkInternalList<String>(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add(ele);
        }
        return this;
    }

    public Command withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList<Target>(targets);
    }

    public Command withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new SdkInternalList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public Command withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setRequestedDateTime(Date requestedDateTime) {
        this.requestedDateTime = requestedDateTime;
    }

    public Date getRequestedDateTime() {
        return this.requestedDateTime;
    }

    public Command withRequestedDateTime(Date requestedDateTime) {
        this.setRequestedDateTime(requestedDateTime);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public Command withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(CommandStatus status) {
        this.withStatus(status);
    }

    public Command withStatus(CommandStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public Command withStatusDetails(String statusDetails) {
        this.setStatusDetails(statusDetails);
        return this;
    }

    public void setOutputS3Region(String outputS3Region) {
        this.outputS3Region = outputS3Region;
    }

    public String getOutputS3Region() {
        return this.outputS3Region;
    }

    public Command withOutputS3Region(String outputS3Region) {
        this.setOutputS3Region(outputS3Region);
        return this;
    }

    public void setOutputS3BucketName(String outputS3BucketName) {
        this.outputS3BucketName = outputS3BucketName;
    }

    public String getOutputS3BucketName() {
        return this.outputS3BucketName;
    }

    public Command withOutputS3BucketName(String outputS3BucketName) {
        this.setOutputS3BucketName(outputS3BucketName);
        return this;
    }

    public void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
        this.outputS3KeyPrefix = outputS3KeyPrefix;
    }

    public String getOutputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Command withOutputS3KeyPrefix(String outputS3KeyPrefix) {
        this.setOutputS3KeyPrefix(outputS3KeyPrefix);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public Command withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public Command withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public void setTargetCount(Integer targetCount) {
        this.targetCount = targetCount;
    }

    public Integer getTargetCount() {
        return this.targetCount;
    }

    public Command withTargetCount(Integer targetCount) {
        this.setTargetCount(targetCount);
        return this;
    }

    public void setCompletedCount(Integer completedCount) {
        this.completedCount = completedCount;
    }

    public Integer getCompletedCount() {
        return this.completedCount;
    }

    public Command withCompletedCount(Integer completedCount) {
        this.setCompletedCount(completedCount);
        return this;
    }

    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }

    public Integer getErrorCount() {
        return this.errorCount;
    }

    public Command withErrorCount(Integer errorCount) {
        this.setErrorCount(errorCount);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public Command withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setNotificationConfig(NotificationConfig notificationConfig) {
        this.notificationConfig = notificationConfig;
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public Command withNotificationConfig(NotificationConfig notificationConfig) {
        this.setNotificationConfig(notificationConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommandId() != null) {
            sb.append("CommandId: ").append(this.getCommandId()).append(",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: ").append(this.getComment()).append(",");
        }
        if (this.getExpiresAfter() != null) {
            sb.append("ExpiresAfter: ").append(this.getExpiresAfter()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: ").append(this.getInstanceIds()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getRequestedDateTime() != null) {
            sb.append("RequestedDateTime: ").append(this.getRequestedDateTime()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusDetails() != null) {
            sb.append("StatusDetails: ").append(this.getStatusDetails()).append(",");
        }
        if (this.getOutputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.getOutputS3Region()).append(",");
        }
        if (this.getOutputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.getOutputS3BucketName()).append(",");
        }
        if (this.getOutputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.getOutputS3KeyPrefix()).append(",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.getMaxConcurrency()).append(",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: ").append(this.getMaxErrors()).append(",");
        }
        if (this.getTargetCount() != null) {
            sb.append("TargetCount: ").append(this.getTargetCount()).append(",");
        }
        if (this.getCompletedCount() != null) {
            sb.append("CompletedCount: ").append(this.getCompletedCount()).append(",");
        }
        if (this.getErrorCount() != null) {
            sb.append("ErrorCount: ").append(this.getErrorCount()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getNotificationConfig() != null) {
            sb.append("NotificationConfig: ").append(this.getNotificationConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        if (other.getCommandId() == null ^ this.getCommandId() == null) {
            return false;
        }
        if (other.getCommandId() != null && !other.getCommandId().equals(this.getCommandId())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getExpiresAfter() == null ^ this.getExpiresAfter() == null) {
            return false;
        }
        if (other.getExpiresAfter() != null && !other.getExpiresAfter().equals(this.getExpiresAfter())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getRequestedDateTime() == null ^ this.getRequestedDateTime() == null) {
            return false;
        }
        if (other.getRequestedDateTime() != null && !other.getRequestedDateTime().equals(this.getRequestedDateTime())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusDetails() == null ^ this.getStatusDetails() == null) {
            return false;
        }
        if (other.getStatusDetails() != null && !other.getStatusDetails().equals(this.getStatusDetails())) {
            return false;
        }
        if (other.getOutputS3Region() == null ^ this.getOutputS3Region() == null) {
            return false;
        }
        if (other.getOutputS3Region() != null && !other.getOutputS3Region().equals(this.getOutputS3Region())) {
            return false;
        }
        if (other.getOutputS3BucketName() == null ^ this.getOutputS3BucketName() == null) {
            return false;
        }
        if (other.getOutputS3BucketName() != null && !other.getOutputS3BucketName().equals(this.getOutputS3BucketName())) {
            return false;
        }
        if (other.getOutputS3KeyPrefix() == null ^ this.getOutputS3KeyPrefix() == null) {
            return false;
        }
        if (other.getOutputS3KeyPrefix() != null && !other.getOutputS3KeyPrefix().equals(this.getOutputS3KeyPrefix())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        if (other.getMaxErrors() != null && !other.getMaxErrors().equals(this.getMaxErrors())) {
            return false;
        }
        if (other.getTargetCount() == null ^ this.getTargetCount() == null) {
            return false;
        }
        if (other.getTargetCount() != null && !other.getTargetCount().equals(this.getTargetCount())) {
            return false;
        }
        if (other.getCompletedCount() == null ^ this.getCompletedCount() == null) {
            return false;
        }
        if (other.getCompletedCount() != null && !other.getCompletedCount().equals(this.getCompletedCount())) {
            return false;
        }
        if (other.getErrorCount() == null ^ this.getErrorCount() == null) {
            return false;
        }
        if (other.getErrorCount() != null && !other.getErrorCount().equals(this.getErrorCount())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getNotificationConfig() == null ^ this.getNotificationConfig() == null) {
            return false;
        }
        return other.getNotificationConfig() == null || other.getNotificationConfig().equals(this.getNotificationConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommandId() == null ? 0 : this.getCommandId().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getExpiresAfter() == null ? 0 : this.getExpiresAfter().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedDateTime() == null ? 0 : this.getRequestedDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusDetails() == null ? 0 : this.getStatusDetails().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3Region() == null ? 0 : this.getOutputS3Region().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3BucketName() == null ? 0 : this.getOutputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3KeyPrefix() == null ? 0 : this.getOutputS3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCount() == null ? 0 : this.getTargetCount().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedCount() == null ? 0 : this.getCompletedCount().hashCode());
        hashCode = 31 * hashCode + (this.getErrorCount() == null ? 0 : this.getErrorCount().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfig() == null ? 0 : this.getNotificationConfig().hashCode());
        return hashCode;
    }

    public Command clone() {
        try {
            return (Command)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

