/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.opsworkscm.model.EngineAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartMaintenanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serverName;
    private List<EngineAttribute> engineAttributes;

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public StartMaintenanceRequest withServerName(String serverName) {
        this.setServerName(serverName);
        return this;
    }

    public List<EngineAttribute> getEngineAttributes() {
        return this.engineAttributes;
    }

    public void setEngineAttributes(Collection<EngineAttribute> engineAttributes) {
        if (engineAttributes == null) {
            this.engineAttributes = null;
            return;
        }
        this.engineAttributes = new ArrayList<EngineAttribute>(engineAttributes);
    }

    public StartMaintenanceRequest withEngineAttributes(EngineAttribute ... engineAttributes) {
        if (this.engineAttributes == null) {
            this.setEngineAttributes(new ArrayList<EngineAttribute>(engineAttributes.length));
        }
        for (EngineAttribute ele : engineAttributes) {
            this.engineAttributes.add(ele);
        }
        return this;
    }

    public StartMaintenanceRequest withEngineAttributes(Collection<EngineAttribute> engineAttributes) {
        this.setEngineAttributes(engineAttributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerName() != null) {
            sb.append("ServerName: ").append(this.getServerName()).append(",");
        }
        if (this.getEngineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.getEngineAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMaintenanceRequest)) {
            return false;
        }
        StartMaintenanceRequest other = (StartMaintenanceRequest)obj;
        if (other.getServerName() == null ^ this.getServerName() == null) {
            return false;
        }
        if (other.getServerName() != null && !other.getServerName().equals(this.getServerName())) {
            return false;
        }
        if (other.getEngineAttributes() == null ^ this.getEngineAttributes() == null) {
            return false;
        }
        return other.getEngineAttributes() == null || other.getEngineAttributes().equals(this.getEngineAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerName() == null ? 0 : this.getServerName().hashCode());
        hashCode = 31 * hashCode + (this.getEngineAttributes() == null ? 0 : this.getEngineAttributes().hashCode());
        return hashCode;
    }

    @Override
    public StartMaintenanceRequest clone() {
        return (StartMaintenanceRequest)super.clone();
    }
}

