/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.DescribeVaultOutput;

@SdkInternalApi
public class DescribeVaultOutputMarshaller {
    private static final MarshallingInfo<String> VAULTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultARN").build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VaultName").build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<String> LASTINVENTORYDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastInventoryDate").build();
    private static final MarshallingInfo<Long> NUMBEROFARCHIVES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfArchives").build();
    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").build();
    private static final DescribeVaultOutputMarshaller instance = new DescribeVaultOutputMarshaller();

    public static DescribeVaultOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(DescribeVaultOutput describeVaultOutput, ProtocolMarshaller protocolMarshaller) {
        if (describeVaultOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(describeVaultOutput.getVaultARN(), VAULTARN_BINDING);
            protocolMarshaller.marshall(describeVaultOutput.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(describeVaultOutput.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(describeVaultOutput.getLastInventoryDate(), LASTINVENTORYDATE_BINDING);
            protocolMarshaller.marshall(describeVaultOutput.getNumberOfArchives(), NUMBEROFARCHIVES_BINDING);
            protocolMarshaller.marshall(describeVaultOutput.getSizeInBytes(), SIZEINBYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

