/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.Command;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListCommandsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Command> commands;
    private String nextToken;

    public List<Command> getCommands() {
        if (this.commands == null) {
            this.commands = new SdkInternalList();
        }
        return this.commands;
    }

    public void setCommands(Collection<Command> commands) {
        if (commands == null) {
            this.commands = null;
            return;
        }
        this.commands = new SdkInternalList<Command>(commands);
    }

    public ListCommandsResult withCommands(Command ... commands) {
        if (this.commands == null) {
            this.setCommands(new SdkInternalList<Command>(commands.length));
        }
        for (Command ele : commands) {
            this.commands.add(ele);
        }
        return this;
    }

    public ListCommandsResult withCommands(Collection<Command> commands) {
        this.setCommands(commands);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCommandsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommands() != null) {
            sb.append("Commands: ").append(this.getCommands()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsResult)) {
            return false;
        }
        ListCommandsResult other = (ListCommandsResult)obj;
        if (other.getCommands() == null ^ this.getCommands() == null) {
            return false;
        }
        if (other.getCommands() != null && !other.getCommands().equals(this.getCommands())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommands() == null ? 0 : this.getCommands().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCommandsResult clone() {
        try {
            return (ListCommandsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

