/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesisfirehose.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The stream and role ARNs for a Kinesis stream used as the source for a delivery stream.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/KinesisStreamSourceConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class KinesisStreamSourceConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ARN of the source Kinesis stream.
     * </p>
     */
    private String kinesisStreamARN;
    /**
     * <p>
     * The ARN of the role that provides access to the source Kinesis stream.
     * </p>
     */
    private String roleARN;

    /**
     * <p>
     * The ARN of the source Kinesis stream.
     * </p>
     * 
     * @param kinesisStreamARN
     *        The ARN of the source Kinesis stream.
     */

    public void setKinesisStreamARN(String kinesisStreamARN) {
        this.kinesisStreamARN = kinesisStreamARN;
    }

    /**
     * <p>
     * The ARN of the source Kinesis stream.
     * </p>
     * 
     * @return The ARN of the source Kinesis stream.
     */

    public String getKinesisStreamARN() {
        return this.kinesisStreamARN;
    }

    /**
     * <p>
     * The ARN of the source Kinesis stream.
     * </p>
     * 
     * @param kinesisStreamARN
     *        The ARN of the source Kinesis stream.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public KinesisStreamSourceConfiguration withKinesisStreamARN(String kinesisStreamARN) {
        setKinesisStreamARN(kinesisStreamARN);
        return this;
    }

    /**
     * <p>
     * The ARN of the role that provides access to the source Kinesis stream.
     * </p>
     * 
     * @param roleARN
     *        The ARN of the role that provides access to the source Kinesis stream.
     */

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    /**
     * <p>
     * The ARN of the role that provides access to the source Kinesis stream.
     * </p>
     * 
     * @return The ARN of the role that provides access to the source Kinesis stream.
     */

    public String getRoleARN() {
        return this.roleARN;
    }

    /**
     * <p>
     * The ARN of the role that provides access to the source Kinesis stream.
     * </p>
     * 
     * @param roleARN
     *        The ARN of the role that provides access to the source Kinesis stream.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public KinesisStreamSourceConfiguration withRoleARN(String roleARN) {
        setRoleARN(roleARN);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKinesisStreamARN() != null)
            sb.append("KinesisStreamARN: ").append(getKinesisStreamARN()).append(",");
        if (getRoleARN() != null)
            sb.append("RoleARN: ").append(getRoleARN());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof KinesisStreamSourceConfiguration == false)
            return false;
        KinesisStreamSourceConfiguration other = (KinesisStreamSourceConfiguration) obj;
        if (other.getKinesisStreamARN() == null ^ this.getKinesisStreamARN() == null)
            return false;
        if (other.getKinesisStreamARN() != null && other.getKinesisStreamARN().equals(this.getKinesisStreamARN()) == false)
            return false;
        if (other.getRoleARN() == null ^ this.getRoleARN() == null)
            return false;
        if (other.getRoleARN() != null && other.getRoleARN().equals(this.getRoleARN()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKinesisStreamARN() == null) ? 0 : getKinesisStreamARN().hashCode());
        hashCode = prime * hashCode + ((getRoleARN() == null) ? 0 : getRoleARN().hashCode());
        return hashCode;
    }

    @Override
    public KinesisStreamSourceConfiguration clone() {
        try {
            return (KinesisStreamSourceConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kinesisfirehose.model.transform.KinesisStreamSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
