/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appmesh;

import javax.annotation.Generated;

import com.amazonaws.services.appmesh.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAppMesh}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppMesh implements AWSAppMesh {

    protected AbstractAWSAppMesh() {
    }

    @Override
    public CreateMeshResult createMesh(CreateMeshRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRouteResult createRoute(CreateRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVirtualNodeResult createVirtualNode(CreateVirtualNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVirtualRouterResult createVirtualRouter(CreateVirtualRouterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMeshResult deleteMesh(DeleteMeshRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRouteResult deleteRoute(DeleteRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVirtualNodeResult deleteVirtualNode(DeleteVirtualNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVirtualRouterResult deleteVirtualRouter(DeleteVirtualRouterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMeshResult describeMesh(DescribeMeshRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRouteResult describeRoute(DescribeRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVirtualNodeResult describeVirtualNode(DescribeVirtualNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVirtualRouterResult describeVirtualRouter(DescribeVirtualRouterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMeshesResult listMeshes(ListMeshesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRoutesResult listRoutes(ListRoutesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVirtualNodesResult listVirtualNodes(ListVirtualNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVirtualRoutersResult listVirtualRouters(ListVirtualRoutersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRouteResult updateRoute(UpdateRouteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVirtualNodeResult updateVirtualNode(UpdateVirtualNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVirtualRouterResult updateVirtualRouter(UpdateVirtualRouterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
