/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceResult;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeCapacityReservationsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * Information about the Capacity Reservations.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<CapacityReservation> capacityReservations;

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *        more results to return.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *        more results to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeCapacityReservationsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * Information about the Capacity Reservations.
     * </p>
     * 
     * @return Information about the Capacity Reservations.
     */

    public java.util.List<CapacityReservation> getCapacityReservations() {
        if (capacityReservations == null) {
            capacityReservations = new com.amazonaws.internal.SdkInternalList<CapacityReservation>();
        }
        return capacityReservations;
    }

    /**
     * <p>
     * Information about the Capacity Reservations.
     * </p>
     * 
     * @param capacityReservations
     *        Information about the Capacity Reservations.
     */

    public void setCapacityReservations(java.util.Collection<CapacityReservation> capacityReservations) {
        if (capacityReservations == null) {
            this.capacityReservations = null;
            return;
        }

        this.capacityReservations = new com.amazonaws.internal.SdkInternalList<CapacityReservation>(capacityReservations);
    }

    /**
     * <p>
     * Information about the Capacity Reservations.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCapacityReservations(java.util.Collection)} or {@link #withCapacityReservations(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param capacityReservations
     *        Information about the Capacity Reservations.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeCapacityReservationsResult withCapacityReservations(CapacityReservation... capacityReservations) {
        if (this.capacityReservations == null) {
            setCapacityReservations(new com.amazonaws.internal.SdkInternalList<CapacityReservation>(capacityReservations.length));
        }
        for (CapacityReservation ele : capacityReservations) {
            this.capacityReservations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the Capacity Reservations.
     * </p>
     * 
     * @param capacityReservations
     *        Information about the Capacity Reservations.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeCapacityReservationsResult withCapacityReservations(java.util.Collection<CapacityReservation> capacityReservations) {
        setCapacityReservations(capacityReservations);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getCapacityReservations() != null)
            sb.append("CapacityReservations: ").append(getCapacityReservations());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeCapacityReservationsResult == false)
            return false;
        DescribeCapacityReservationsResult other = (DescribeCapacityReservationsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getCapacityReservations() == null ^ this.getCapacityReservations() == null)
            return false;
        if (other.getCapacityReservations() != null && other.getCapacityReservations().equals(this.getCapacityReservations()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getCapacityReservations() == null) ? 0 : getCapacityReservations().hashCode());
        return hashCode;
    }

    @Override
    public DescribeCapacityReservationsResult clone() {
        try {
            return (DescribeCapacityReservationsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }
}
