/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelbuilding;

import javax.annotation.Generated;

import com.amazonaws.services.lexmodelbuilding.model.*;

/**
 * Abstract implementation of {@code AmazonLexModelBuildingAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLexModelBuildingAsync extends AbstractAmazonLexModelBuilding implements AmazonLexModelBuildingAsync {

    protected AbstractAmazonLexModelBuildingAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateBotVersionResult> createBotVersionAsync(CreateBotVersionRequest request) {

        return createBotVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBotVersionResult> createBotVersionAsync(CreateBotVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBotVersionRequest, CreateBotVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIntentVersionResult> createIntentVersionAsync(CreateIntentVersionRequest request) {

        return createIntentVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIntentVersionResult> createIntentVersionAsync(CreateIntentVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIntentVersionRequest, CreateIntentVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSlotTypeVersionResult> createSlotTypeVersionAsync(CreateSlotTypeVersionRequest request) {

        return createSlotTypeVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSlotTypeVersionResult> createSlotTypeVersionAsync(CreateSlotTypeVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSlotTypeVersionRequest, CreateSlotTypeVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBotResult> deleteBotAsync(DeleteBotRequest request) {

        return deleteBotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBotResult> deleteBotAsync(DeleteBotRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBotRequest, DeleteBotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBotAliasResult> deleteBotAliasAsync(DeleteBotAliasRequest request) {

        return deleteBotAliasAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBotAliasResult> deleteBotAliasAsync(DeleteBotAliasRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBotAliasRequest, DeleteBotAliasResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBotChannelAssociationResult> deleteBotChannelAssociationAsync(DeleteBotChannelAssociationRequest request) {

        return deleteBotChannelAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBotChannelAssociationResult> deleteBotChannelAssociationAsync(DeleteBotChannelAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBotChannelAssociationRequest, DeleteBotChannelAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBotVersionResult> deleteBotVersionAsync(DeleteBotVersionRequest request) {

        return deleteBotVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBotVersionResult> deleteBotVersionAsync(DeleteBotVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBotVersionRequest, DeleteBotVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIntentResult> deleteIntentAsync(DeleteIntentRequest request) {

        return deleteIntentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIntentResult> deleteIntentAsync(DeleteIntentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIntentRequest, DeleteIntentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIntentVersionResult> deleteIntentVersionAsync(DeleteIntentVersionRequest request) {

        return deleteIntentVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIntentVersionResult> deleteIntentVersionAsync(DeleteIntentVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIntentVersionRequest, DeleteIntentVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSlotTypeResult> deleteSlotTypeAsync(DeleteSlotTypeRequest request) {

        return deleteSlotTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSlotTypeResult> deleteSlotTypeAsync(DeleteSlotTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSlotTypeRequest, DeleteSlotTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSlotTypeVersionResult> deleteSlotTypeVersionAsync(DeleteSlotTypeVersionRequest request) {

        return deleteSlotTypeVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSlotTypeVersionResult> deleteSlotTypeVersionAsync(DeleteSlotTypeVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSlotTypeVersionRequest, DeleteSlotTypeVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteUtterancesResult> deleteUtterancesAsync(DeleteUtterancesRequest request) {

        return deleteUtterancesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteUtterancesResult> deleteUtterancesAsync(DeleteUtterancesRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteUtterancesRequest, DeleteUtterancesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotResult> getBotAsync(GetBotRequest request) {

        return getBotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotResult> getBotAsync(GetBotRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotRequest, GetBotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotAliasResult> getBotAliasAsync(GetBotAliasRequest request) {

        return getBotAliasAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotAliasResult> getBotAliasAsync(GetBotAliasRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotAliasRequest, GetBotAliasResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotAliasesResult> getBotAliasesAsync(GetBotAliasesRequest request) {

        return getBotAliasesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotAliasesResult> getBotAliasesAsync(GetBotAliasesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotAliasesRequest, GetBotAliasesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotChannelAssociationResult> getBotChannelAssociationAsync(GetBotChannelAssociationRequest request) {

        return getBotChannelAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotChannelAssociationResult> getBotChannelAssociationAsync(GetBotChannelAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotChannelAssociationRequest, GetBotChannelAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotChannelAssociationsResult> getBotChannelAssociationsAsync(GetBotChannelAssociationsRequest request) {

        return getBotChannelAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotChannelAssociationsResult> getBotChannelAssociationsAsync(GetBotChannelAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotChannelAssociationsRequest, GetBotChannelAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotVersionsResult> getBotVersionsAsync(GetBotVersionsRequest request) {

        return getBotVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotVersionsResult> getBotVersionsAsync(GetBotVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotVersionsRequest, GetBotVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBotsResult> getBotsAsync(GetBotsRequest request) {

        return getBotsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBotsResult> getBotsAsync(GetBotsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBotsRequest, GetBotsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBuiltinIntentResult> getBuiltinIntentAsync(GetBuiltinIntentRequest request) {

        return getBuiltinIntentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBuiltinIntentResult> getBuiltinIntentAsync(GetBuiltinIntentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBuiltinIntentRequest, GetBuiltinIntentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBuiltinIntentsResult> getBuiltinIntentsAsync(GetBuiltinIntentsRequest request) {

        return getBuiltinIntentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBuiltinIntentsResult> getBuiltinIntentsAsync(GetBuiltinIntentsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBuiltinIntentsRequest, GetBuiltinIntentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBuiltinSlotTypesResult> getBuiltinSlotTypesAsync(GetBuiltinSlotTypesRequest request) {

        return getBuiltinSlotTypesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBuiltinSlotTypesResult> getBuiltinSlotTypesAsync(GetBuiltinSlotTypesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBuiltinSlotTypesRequest, GetBuiltinSlotTypesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetExportResult> getExportAsync(GetExportRequest request) {

        return getExportAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetExportResult> getExportAsync(GetExportRequest request,
            com.amazonaws.handlers.AsyncHandler<GetExportRequest, GetExportResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetImportResult> getImportAsync(GetImportRequest request) {

        return getImportAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetImportResult> getImportAsync(GetImportRequest request,
            com.amazonaws.handlers.AsyncHandler<GetImportRequest, GetImportResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIntentResult> getIntentAsync(GetIntentRequest request) {

        return getIntentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIntentResult> getIntentAsync(GetIntentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIntentRequest, GetIntentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIntentVersionsResult> getIntentVersionsAsync(GetIntentVersionsRequest request) {

        return getIntentVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIntentVersionsResult> getIntentVersionsAsync(GetIntentVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIntentVersionsRequest, GetIntentVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIntentsResult> getIntentsAsync(GetIntentsRequest request) {

        return getIntentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIntentsResult> getIntentsAsync(GetIntentsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIntentsRequest, GetIntentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSlotTypeResult> getSlotTypeAsync(GetSlotTypeRequest request) {

        return getSlotTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSlotTypeResult> getSlotTypeAsync(GetSlotTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSlotTypeRequest, GetSlotTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSlotTypeVersionsResult> getSlotTypeVersionsAsync(GetSlotTypeVersionsRequest request) {

        return getSlotTypeVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSlotTypeVersionsResult> getSlotTypeVersionsAsync(GetSlotTypeVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSlotTypeVersionsRequest, GetSlotTypeVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSlotTypesResult> getSlotTypesAsync(GetSlotTypesRequest request) {

        return getSlotTypesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSlotTypesResult> getSlotTypesAsync(GetSlotTypesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSlotTypesRequest, GetSlotTypesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetUtterancesViewResult> getUtterancesViewAsync(GetUtterancesViewRequest request) {

        return getUtterancesViewAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetUtterancesViewResult> getUtterancesViewAsync(GetUtterancesViewRequest request,
            com.amazonaws.handlers.AsyncHandler<GetUtterancesViewRequest, GetUtterancesViewResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutBotResult> putBotAsync(PutBotRequest request) {

        return putBotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBotResult> putBotAsync(PutBotRequest request,
            com.amazonaws.handlers.AsyncHandler<PutBotRequest, PutBotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutBotAliasResult> putBotAliasAsync(PutBotAliasRequest request) {

        return putBotAliasAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBotAliasResult> putBotAliasAsync(PutBotAliasRequest request,
            com.amazonaws.handlers.AsyncHandler<PutBotAliasRequest, PutBotAliasResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutIntentResult> putIntentAsync(PutIntentRequest request) {

        return putIntentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutIntentResult> putIntentAsync(PutIntentRequest request,
            com.amazonaws.handlers.AsyncHandler<PutIntentRequest, PutIntentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutSlotTypeResult> putSlotTypeAsync(PutSlotTypeRequest request) {

        return putSlotTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutSlotTypeResult> putSlotTypeAsync(PutSlotTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<PutSlotTypeRequest, PutSlotTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartImportResult> startImportAsync(StartImportRequest request) {

        return startImportAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartImportResult> startImportAsync(StartImportRequest request,
            com.amazonaws.handlers.AsyncHandler<StartImportRequest, StartImportResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
