/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.rekognition.model.*;

import com.amazonaws.protocol.json.*;

/**
 * PoseMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PoseJsonMarshaller {

    /**
     * Marshall the given parameter object, and output to a SdkJsonGenerator
     */
    public void marshall(Pose pose, StructuredJsonGenerator jsonGenerator) {

        if (pose == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            jsonGenerator.writeStartObject();

            if (pose.getRoll() != null) {
                jsonGenerator.writeFieldName("Roll").writeValue(pose.getRoll());
            }
            if (pose.getYaw() != null) {
                jsonGenerator.writeFieldName("Yaw").writeValue(pose.getYaw());
            }
            if (pose.getPitch() != null) {
                jsonGenerator.writeFieldName("Pitch").writeValue(pose.getPitch());
            }

            jsonGenerator.writeEndObject();
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private static PoseJsonMarshaller instance;

    public static PoseJsonMarshaller getInstance() {
        if (instance == null)
            instance = new PoseJsonMarshaller();
        return instance;
    }

}
