/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.DocumentationVersion;

public class DocumentationVersionJsonMarshaller {
    private static DocumentationVersionJsonMarshaller instance;

    public void marshall(DocumentationVersion documentationVersion, StructuredJsonGenerator jsonGenerator) {
        if (documentationVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (documentationVersion.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(documentationVersion.getVersion());
            }
            if (documentationVersion.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(documentationVersion.getCreatedDate());
            }
            if (documentationVersion.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(documentationVersion.getDescription());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DocumentationVersionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentationVersionJsonMarshaller();
        }
        return instance;
    }
}

