/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.AddIpRoutesRequest;
import com.amazonaws.services.directory.model.IpRoute;
import com.amazonaws.services.directory.model.transform.IpRouteJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AddIpRoutesRequestMarshaller
implements Marshaller<Request<AddIpRoutesRequest>, AddIpRoutesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AddIpRoutesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddIpRoutesRequest> marshall(AddIpRoutesRequest addIpRoutesRequest) {
        if (addIpRoutesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddIpRoutesRequest> request = new DefaultRequest<AddIpRoutesRequest>(addIpRoutesRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.AddIpRoutes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList ipRoutesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addIpRoutesRequest.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(addIpRoutesRequest.getDirectoryId());
            }
            if (!(ipRoutesList = (SdkInternalList)addIpRoutesRequest.getIpRoutes()).isEmpty() || !ipRoutesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("IpRoutes");
                jsonGenerator.writeStartArray();
                for (IpRoute ipRoutesListValue : ipRoutesList) {
                    if (ipRoutesListValue == null) continue;
                    IpRouteJsonMarshaller.getInstance().marshall(ipRoutesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (addIpRoutesRequest.getUpdateSecurityGroupForDirectoryControllers() != null) {
                jsonGenerator.writeFieldName("UpdateSecurityGroupForDirectoryControllers").writeValue(addIpRoutesRequest.getUpdateSecurityGroupForDirectoryControllers());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

