/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.DeploymentConfiguration;

public class DeploymentConfigurationJsonMarshaller {
    private static DeploymentConfigurationJsonMarshaller instance;

    public void marshall(DeploymentConfiguration deploymentConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (deploymentConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (deploymentConfiguration.getMaximumPercent() != null) {
                jsonGenerator.writeFieldName("maximumPercent").writeValue(deploymentConfiguration.getMaximumPercent());
            }
            if (deploymentConfiguration.getMinimumHealthyPercent() != null) {
                jsonGenerator.writeFieldName("minimumHealthyPercent").writeValue(deploymentConfiguration.getMinimumHealthyPercent());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentConfigurationJsonMarshaller();
        }
        return instance;
    }
}

