/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignActivitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetCampaignActivitiesRequestMarshaller
implements Marshaller<Request<GetCampaignActivitiesRequest>, GetCampaignActivitiesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetCampaignActivitiesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetCampaignActivitiesRequest> marshall(GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        if (getCampaignActivitiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetCampaignActivitiesRequest> request = new DefaultRequest<GetCampaignActivitiesRequest>(getCampaignActivitiesRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}/activities";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", getCampaignActivitiesRequest.getApplicationId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "campaign-id", getCampaignActivitiesRequest.getCampaignId());
        request.setResourcePath(uriResourcePath);
        if (getCampaignActivitiesRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString(getCampaignActivitiesRequest.getPageSize()));
        }
        if (getCampaignActivitiesRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString(getCampaignActivitiesRequest.getToken()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

