/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTask;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskParameterValueExpression;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.LoggingInfoJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.MaintenanceWindowTaskParameterValueExpressionJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.TargetJsonMarshaller;
import java.util.Map;

public class MaintenanceWindowTaskJsonMarshaller {
    private static MaintenanceWindowTaskJsonMarshaller instance;

    public void marshall(MaintenanceWindowTask maintenanceWindowTask, StructuredJsonGenerator jsonGenerator) {
        if (maintenanceWindowTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, MaintenanceWindowTaskParameterValueExpression> taskParametersMap;
            SdkInternalList targetsList;
            jsonGenerator.writeStartObject();
            if (maintenanceWindowTask.getWindowId() != null) {
                jsonGenerator.writeFieldName("WindowId").writeValue(maintenanceWindowTask.getWindowId());
            }
            if (maintenanceWindowTask.getWindowTaskId() != null) {
                jsonGenerator.writeFieldName("WindowTaskId").writeValue(maintenanceWindowTask.getWindowTaskId());
            }
            if (maintenanceWindowTask.getTaskArn() != null) {
                jsonGenerator.writeFieldName("TaskArn").writeValue(maintenanceWindowTask.getTaskArn());
            }
            if (maintenanceWindowTask.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(maintenanceWindowTask.getType());
            }
            if (!(targetsList = (SdkInternalList)maintenanceWindowTask.getTargets()).isEmpty() || !targetsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Targets");
                jsonGenerator.writeStartArray();
                for (Target targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall(targetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((taskParametersMap = maintenanceWindowTask.getTaskParameters()) != null) {
                jsonGenerator.writeFieldName("TaskParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, MaintenanceWindowTaskParameterValueExpression> taskParametersMapValue : taskParametersMap.entrySet()) {
                    if (taskParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(taskParametersMapValue.getKey());
                    MaintenanceWindowTaskParameterValueExpressionJsonMarshaller.getInstance().marshall(taskParametersMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (maintenanceWindowTask.getPriority() != null) {
                jsonGenerator.writeFieldName("Priority").writeValue(maintenanceWindowTask.getPriority());
            }
            if (maintenanceWindowTask.getLoggingInfo() != null) {
                jsonGenerator.writeFieldName("LoggingInfo");
                LoggingInfoJsonMarshaller.getInstance().marshall(maintenanceWindowTask.getLoggingInfo(), jsonGenerator);
            }
            if (maintenanceWindowTask.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(maintenanceWindowTask.getServiceRoleArn());
            }
            if (maintenanceWindowTask.getMaxConcurrency() != null) {
                jsonGenerator.writeFieldName("MaxConcurrency").writeValue(maintenanceWindowTask.getMaxConcurrency());
            }
            if (maintenanceWindowTask.getMaxErrors() != null) {
                jsonGenerator.writeFieldName("MaxErrors").writeValue(maintenanceWindowTask.getMaxErrors());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MaintenanceWindowTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MaintenanceWindowTaskJsonMarshaller();
        }
        return instance;
    }
}

