/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf_regional.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.Predicate;
import com.amazonaws.services.waf.model.Rule;
import com.amazonaws.services.waf.model.waf_regional.transform.PredicateJsonMarshaller;
import java.util.List;

public class RuleJsonMarshaller {
    private static RuleJsonMarshaller instance;

    public void marshall(Rule rule, StructuredJsonGenerator jsonGenerator) {
        if (rule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Predicate> predicatesList;
            jsonGenerator.writeStartObject();
            if (rule.getRuleId() != null) {
                jsonGenerator.writeFieldName("RuleId").writeValue(rule.getRuleId());
            }
            if (rule.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(rule.getName());
            }
            if (rule.getMetricName() != null) {
                jsonGenerator.writeFieldName("MetricName").writeValue(rule.getMetricName());
            }
            if ((predicatesList = rule.getPredicates()) != null) {
                jsonGenerator.writeFieldName("Predicates");
                jsonGenerator.writeStartArray();
                for (Predicate predicatesListValue : predicatesList) {
                    if (predicatesListValue == null) continue;
                    PredicateJsonMarshaller.getInstance().marshall(predicatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RuleJsonMarshaller();
        }
        return instance;
    }
}

