/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codepipeline.model.transform;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.codepipeline.model.*;

import com.amazonaws.protocol.json.*;

/**
 * ActionConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ActionConfigurationJsonMarshaller {

    /**
     * Marshall the given parameter object, and output to a SdkJsonGenerator
     */
    public void marshall(ActionConfiguration actionConfiguration, StructuredJsonGenerator jsonGenerator) {

        if (actionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            jsonGenerator.writeStartObject();

            java.util.Map<String, String> configurationMap = actionConfiguration.getConfiguration();
            if (configurationMap != null) {
                jsonGenerator.writeFieldName("configuration");
                jsonGenerator.writeStartObject();

                for (Map.Entry<String, String> configurationMapValue : configurationMap.entrySet()) {
                    if (configurationMapValue.getValue() != null) {
                        jsonGenerator.writeFieldName(configurationMapValue.getKey());

                        jsonGenerator.writeValue(configurationMapValue.getValue());
                    }
                }
                jsonGenerator.writeEndObject();
            }

            jsonGenerator.writeEndObject();
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private static ActionConfigurationJsonMarshaller instance;

    public static ActionConfigurationJsonMarshaller getInstance() {
        if (instance == null)
            instance = new ActionConfigurationJsonMarshaller();
        return instance;
    }

}
