/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import java.io.ByteArrayInputStream;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidp.model.*;
import com.amazonaws.transform.Marshaller;

import com.amazonaws.protocol.json.*;

/**
 * AdminInitiateAuthRequest Marshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AdminInitiateAuthRequestMarshaller implements Marshaller<Request<AdminInitiateAuthRequest>, AdminInitiateAuthRequest> {

    private final SdkJsonMarshallerFactory protocolFactory;

    public AdminInitiateAuthRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AdminInitiateAuthRequest> marshall(AdminInitiateAuthRequest adminInitiateAuthRequest) {

        if (adminInitiateAuthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AdminInitiateAuthRequest> request = new DefaultRequest<AdminInitiateAuthRequest>(adminInitiateAuthRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminInitiateAuth");

        request.setHttpMethod(HttpMethodName.POST);

        request.setResourcePath("");

        try {
            final StructuredJsonGenerator jsonGenerator = protocolFactory.createGenerator();

            jsonGenerator.writeStartObject();

            if (adminInitiateAuthRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminInitiateAuthRequest.getUserPoolId());
            }
            if (adminInitiateAuthRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(adminInitiateAuthRequest.getClientId());
            }
            if (adminInitiateAuthRequest.getAuthFlow() != null) {
                jsonGenerator.writeFieldName("AuthFlow").writeValue(adminInitiateAuthRequest.getAuthFlow());
            }

            java.util.Map<String, String> authParametersMap = adminInitiateAuthRequest.getAuthParameters();
            if (authParametersMap != null) {
                jsonGenerator.writeFieldName("AuthParameters");
                jsonGenerator.writeStartObject();

                for (Map.Entry<String, String> authParametersMapValue : authParametersMap.entrySet()) {
                    if (authParametersMapValue.getValue() != null) {
                        jsonGenerator.writeFieldName(authParametersMapValue.getKey());

                        jsonGenerator.writeValue(authParametersMapValue.getValue());
                    }
                }
                jsonGenerator.writeEndObject();
            }

            java.util.Map<String, String> clientMetadataMap = adminInitiateAuthRequest.getClientMetadata();
            if (clientMetadataMap != null) {
                jsonGenerator.writeFieldName("ClientMetadata");
                jsonGenerator.writeStartObject();

                for (Map.Entry<String, String> clientMetadataMapValue : clientMetadataMap.entrySet()) {
                    if (clientMetadataMapValue.getValue() != null) {
                        jsonGenerator.writeFieldName(clientMetadataMapValue.getKey());

                        jsonGenerator.writeValue(clientMetadataMapValue.getValue());
                    }
                }
                jsonGenerator.writeEndObject();
            }

            jsonGenerator.writeEndObject();

            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", protocolFactory.getContentType());
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }

        return request;
    }

}
