/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerAsync;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerClient;
import com.amazonaws.services.certificatemanager.model.AddTagsToCertificateRequest;
import com.amazonaws.services.certificatemanager.model.AddTagsToCertificateResult;
import com.amazonaws.services.certificatemanager.model.DeleteCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DeleteCertificateResult;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateResult;
import com.amazonaws.services.certificatemanager.model.GetCertificateRequest;
import com.amazonaws.services.certificatemanager.model.GetCertificateResult;
import com.amazonaws.services.certificatemanager.model.ImportCertificateRequest;
import com.amazonaws.services.certificatemanager.model.ImportCertificateResult;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.services.certificatemanager.model.ListCertificatesResult;
import com.amazonaws.services.certificatemanager.model.ListTagsForCertificateRequest;
import com.amazonaws.services.certificatemanager.model.ListTagsForCertificateResult;
import com.amazonaws.services.certificatemanager.model.RemoveTagsFromCertificateRequest;
import com.amazonaws.services.certificatemanager.model.RemoveTagsFromCertificateResult;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.RequestCertificateResult;
import com.amazonaws.services.certificatemanager.model.ResendValidationEmailRequest;
import com.amazonaws.services.certificatemanager.model.ResendValidationEmailResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCertificateManagerAsyncClient
extends AWSCertificateManagerClient
implements AWSCertificateManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSCertificateManagerAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCertificateManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToCertificateResult> addTagsToCertificateAsync(AddTagsToCertificateRequest request) {
        return this.addTagsToCertificateAsync(request, null);
    }

    @Override
    public Future<AddTagsToCertificateResult> addTagsToCertificateAsync(final AddTagsToCertificateRequest request, final AsyncHandler<AddTagsToCertificateRequest, AddTagsToCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsToCertificateResult>(){

            @Override
            public AddTagsToCertificateResult call() throws Exception {
                AddTagsToCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.addTagsToCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCertificateResult> deleteCertificateAsync(DeleteCertificateRequest request) {
        return this.deleteCertificateAsync(request, null);
    }

    @Override
    public Future<DeleteCertificateResult> deleteCertificateAsync(final DeleteCertificateRequest request, final AsyncHandler<DeleteCertificateRequest, DeleteCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCertificateResult>(){

            @Override
            public DeleteCertificateResult call() throws Exception {
                DeleteCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.deleteCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(DescribeCertificateRequest request) {
        return this.describeCertificateAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(final DescribeCertificateRequest request, final AsyncHandler<DescribeCertificateRequest, DescribeCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCertificateResult>(){

            @Override
            public DescribeCertificateResult call() throws Exception {
                DescribeCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.describeCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(GetCertificateRequest request) {
        return this.getCertificateAsync(request, null);
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(final GetCertificateRequest request, final AsyncHandler<GetCertificateRequest, GetCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCertificateResult>(){

            @Override
            public GetCertificateResult call() throws Exception {
                GetCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.getCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportCertificateResult> importCertificateAsync(ImportCertificateRequest request) {
        return this.importCertificateAsync(request, null);
    }

    @Override
    public Future<ImportCertificateResult> importCertificateAsync(final ImportCertificateRequest request, final AsyncHandler<ImportCertificateRequest, ImportCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<ImportCertificateResult>(){

            @Override
            public ImportCertificateResult call() throws Exception {
                ImportCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.importCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(ListCertificatesRequest request) {
        return this.listCertificatesAsync(request, null);
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(final ListCertificatesRequest request, final AsyncHandler<ListCertificatesRequest, ListCertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCertificatesResult>(){

            @Override
            public ListCertificatesResult call() throws Exception {
                ListCertificatesResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.listCertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForCertificateResult> listTagsForCertificateAsync(ListTagsForCertificateRequest request) {
        return this.listTagsForCertificateAsync(request, null);
    }

    @Override
    public Future<ListTagsForCertificateResult> listTagsForCertificateAsync(final ListTagsForCertificateRequest request, final AsyncHandler<ListTagsForCertificateRequest, ListTagsForCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForCertificateResult>(){

            @Override
            public ListTagsForCertificateResult call() throws Exception {
                ListTagsForCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.listTagsForCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromCertificateResult> removeTagsFromCertificateAsync(RemoveTagsFromCertificateRequest request) {
        return this.removeTagsFromCertificateAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromCertificateResult> removeTagsFromCertificateAsync(final RemoveTagsFromCertificateRequest request, final AsyncHandler<RemoveTagsFromCertificateRequest, RemoveTagsFromCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsFromCertificateResult>(){

            @Override
            public RemoveTagsFromCertificateResult call() throws Exception {
                RemoveTagsFromCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.removeTagsFromCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RequestCertificateResult> requestCertificateAsync(RequestCertificateRequest request) {
        return this.requestCertificateAsync(request, null);
    }

    @Override
    public Future<RequestCertificateResult> requestCertificateAsync(final RequestCertificateRequest request, final AsyncHandler<RequestCertificateRequest, RequestCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<RequestCertificateResult>(){

            @Override
            public RequestCertificateResult call() throws Exception {
                RequestCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.requestCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResendValidationEmailResult> resendValidationEmailAsync(ResendValidationEmailRequest request) {
        return this.resendValidationEmailAsync(request, null);
    }

    @Override
    public Future<ResendValidationEmailResult> resendValidationEmailAsync(final ResendValidationEmailRequest request, final AsyncHandler<ResendValidationEmailRequest, ResendValidationEmailResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResendValidationEmailResult>(){

            @Override
            public ResendValidationEmailResult call() throws Exception {
                ResendValidationEmailResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.resendValidationEmail(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

