/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathLengthFunction;
import com.amazonaws.jmespath.JmesPathLiteral;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.jmespath.OpGreaterThan;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class KeyPairExists {
    KeyPairExists() {
    }

    static class IsInvalidKeyPairNotFoundMatcher
    extends WaiterAcceptor<DescribeKeyPairsResult> {
        IsInvalidKeyPairNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "InvalidKeyPair.NotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsTrueMatcher
    extends WaiterAcceptor<DescribeKeyPairsResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsTrueMatcher() {
        }

        @Override
        public boolean matches(DescribeKeyPairsResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("true");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new OpGreaterThan(new JmesPathLengthFunction(new JmesPathProjection(new JmesPathFlatten(new JmesPathField("KeyPairs")), new JmesPathField("KeyName"))), new JmesPathLiteral("0"));
        }
    }
}

