/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class DeleteVaultRequestMarshaller
implements Marshaller<Request<DeleteVaultRequest>, DeleteVaultRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteVaultRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteVaultRequest> marshall(DeleteVaultRequest deleteVaultRequest) {
        if (deleteVaultRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteVaultRequest> request = new DefaultRequest<DeleteVaultRequest>(deleteVaultRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", deleteVaultRequest.getAccountId() == null ? "-" : deleteVaultRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", deleteVaultRequest.getVaultName());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

