/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker;

import javax.annotation.Generated;

import com.amazonaws.services.sagemaker.model.*;
import com.amazonaws.*;
import com.amazonaws.services.sagemaker.waiters.AmazonSageMakerWaiters;

/**
 * Abstract implementation of {@code AmazonSageMaker}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonSageMaker implements AmazonSageMaker {

    protected AbstractAmazonSageMaker() {
    }

    @Override
    public AddTagsResult addTags(AddTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTrialComponentResult associateTrialComponent(AssociateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAlgorithmResult createAlgorithm(CreateAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppResult createApp(CreateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAutoMLJobResult createAutoMLJob(CreateAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCodeRepositoryResult createCodeRepository(CreateCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCompilationJobResult createCompilationJob(CreateCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointResult createEndpoint(CreateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointConfigResult createEndpointConfig(CreateEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateExperimentResult createExperiment(CreateExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowDefinitionResult createFlowDefinition(CreateFlowDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHumanTaskUiResult createHumanTaskUi(CreateHumanTaskUiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHyperParameterTuningJobResult createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLabelingJobResult createLabelingJob(CreateLabelingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelPackageResult createModelPackage(CreateModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMonitoringScheduleResult createMonitoringSchedule(CreateMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotebookInstanceResult createNotebookInstance(CreateNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotebookInstanceLifecycleConfigResult createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresignedDomainUrlResult createPresignedDomainUrl(CreatePresignedDomainUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresignedNotebookInstanceUrlResult createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProcessingJobResult createProcessingJob(CreateProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrainingJobResult createTrainingJob(CreateTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTransformJobResult createTransformJob(CreateTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrialResult createTrial(CreateTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrialComponentResult createTrialComponent(CreateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserProfileResult createUserProfile(CreateUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkforceResult createWorkforce(CreateWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkteamResult createWorkteam(CreateWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAlgorithmResult deleteAlgorithm(DeleteAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppResult deleteApp(DeleteAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCodeRepositoryResult deleteCodeRepository(DeleteCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointResult deleteEndpoint(DeleteEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointConfigResult deleteEndpointConfig(DeleteEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExperimentResult deleteExperiment(DeleteExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowDefinitionResult deleteFlowDefinition(DeleteFlowDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHumanTaskUiResult deleteHumanTaskUi(DeleteHumanTaskUiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelPackageResult deleteModelPackage(DeleteModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMonitoringScheduleResult deleteMonitoringSchedule(DeleteMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotebookInstanceResult deleteNotebookInstance(DeleteNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotebookInstanceLifecycleConfigResult deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrialResult deleteTrial(DeleteTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrialComponentResult deleteTrialComponent(DeleteTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserProfileResult deleteUserProfile(DeleteUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkforceResult deleteWorkforce(DeleteWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkteamResult deleteWorkteam(DeleteWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAlgorithmResult describeAlgorithm(DescribeAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppResult describeApp(DescribeAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAutoMLJobResult describeAutoMLJob(DescribeAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCodeRepositoryResult describeCodeRepository(DescribeCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCompilationJobResult describeCompilationJob(DescribeCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDomainResult describeDomain(DescribeDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointResult describeEndpoint(DescribeEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointConfigResult describeEndpointConfig(DescribeEndpointConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeExperimentResult describeExperiment(DescribeExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFlowDefinitionResult describeFlowDefinition(DescribeFlowDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHumanTaskUiResult describeHumanTaskUi(DescribeHumanTaskUiRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHyperParameterTuningJobResult describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLabelingJobResult describeLabelingJob(DescribeLabelingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelResult describeModel(DescribeModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelPackageResult describeModelPackage(DescribeModelPackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMonitoringScheduleResult describeMonitoringSchedule(DescribeMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotebookInstanceResult describeNotebookInstance(DescribeNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotebookInstanceLifecycleConfigResult describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProcessingJobResult describeProcessingJob(DescribeProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSubscribedWorkteamResult describeSubscribedWorkteam(DescribeSubscribedWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrainingJobResult describeTrainingJob(DescribeTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTransformJobResult describeTransformJob(DescribeTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrialResult describeTrial(DescribeTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrialComponentResult describeTrialComponent(DescribeTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUserProfileResult describeUserProfile(DescribeUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkforceResult describeWorkforce(DescribeWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkteamResult describeWorkteam(DescribeWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTrialComponentResult disassociateTrialComponent(DisassociateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSearchSuggestionsResult getSearchSuggestions(GetSearchSuggestionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAlgorithmsResult listAlgorithms(ListAlgorithmsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppsResult listApps(ListAppsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAutoMLJobsResult listAutoMLJobs(ListAutoMLJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCandidatesForAutoMLJobResult listCandidatesForAutoMLJob(ListCandidatesForAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCodeRepositoriesResult listCodeRepositories(ListCodeRepositoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCompilationJobsResult listCompilationJobs(ListCompilationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointConfigsResult listEndpointConfigs(ListEndpointConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointsResult listEndpoints(ListEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentsResult listExperiments(ListExperimentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowDefinitionsResult listFlowDefinitions(ListFlowDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHumanTaskUisResult listHumanTaskUis(ListHumanTaskUisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHyperParameterTuningJobsResult listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLabelingJobsResult listLabelingJobs(ListLabelingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLabelingJobsForWorkteamResult listLabelingJobsForWorkteam(ListLabelingJobsForWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelPackagesResult listModelPackages(ListModelPackagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListModelsResult listModels(ListModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitoringExecutionsResult listMonitoringExecutions(ListMonitoringExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMonitoringSchedulesResult listMonitoringSchedules(ListMonitoringSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotebookInstanceLifecycleConfigsResult listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotebookInstancesResult listNotebookInstances(ListNotebookInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProcessingJobsResult listProcessingJobs(ListProcessingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscribedWorkteamsResult listSubscribedWorkteams(ListSubscribedWorkteamsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingJobsResult listTrainingJobs(ListTrainingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingJobsForHyperParameterTuningJobResult listTrainingJobsForHyperParameterTuningJob(ListTrainingJobsForHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTransformJobsResult listTransformJobs(ListTransformJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrialComponentsResult listTrialComponents(ListTrialComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrialsResult listTrials(ListTrialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUserProfilesResult listUserProfiles(ListUserProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkforcesResult listWorkforces(ListWorkforcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkteamsResult listWorkteams(ListWorkteamsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RenderUiTemplateResult renderUiTemplate(RenderUiTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchResult search(SearchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMonitoringScheduleResult startMonitoringSchedule(StartMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartNotebookInstanceResult startNotebookInstance(StartNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopAutoMLJobResult stopAutoMLJob(StopAutoMLJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopCompilationJobResult stopCompilationJob(StopCompilationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopHyperParameterTuningJobResult stopHyperParameterTuningJob(StopHyperParameterTuningJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopLabelingJobResult stopLabelingJob(StopLabelingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopMonitoringScheduleResult stopMonitoringSchedule(StopMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopNotebookInstanceResult stopNotebookInstance(StopNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopProcessingJobResult stopProcessingJob(StopProcessingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingJobResult stopTrainingJob(StopTrainingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTransformJobResult stopTransformJob(StopTransformJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCodeRepositoryResult updateCodeRepository(UpdateCodeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainResult updateDomain(UpdateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointResult updateEndpoint(UpdateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointWeightsAndCapacitiesResult updateEndpointWeightsAndCapacities(UpdateEndpointWeightsAndCapacitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateExperimentResult updateExperiment(UpdateExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMonitoringScheduleResult updateMonitoringSchedule(UpdateMonitoringScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotebookInstanceResult updateNotebookInstance(UpdateNotebookInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotebookInstanceLifecycleConfigResult updateNotebookInstanceLifecycleConfig(UpdateNotebookInstanceLifecycleConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrialResult updateTrial(UpdateTrialRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrialComponentResult updateTrialComponent(UpdateTrialComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserProfileResult updateUserProfile(UpdateUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkforceResult updateWorkforce(UpdateWorkforceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkteamResult updateWorkteam(UpdateWorkteamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonSageMakerWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
