/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.identitystore.model;

import javax.annotation.Generated;

/**
 * <p>
 * Indicates that a requested resource is not found.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ResourceNotFoundException extends com.amazonaws.services.identitystore.model.AWSIdentityStoreException {
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     */
    private String resourceType;
    /**
     * <p>
     * The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     * <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     * <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it is
     * created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the case that
     * the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that identity
     * store will be in the format of <code>UUID</code>. Otherwise, it will be in the <code>1234567890-UUID</code>
     * format.
     * </p>
     */
    private String resourceId;
    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     */
    private String requestId;

    /**
     * Constructs a new ResourceNotFoundException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public ResourceNotFoundException(String message) {
        super(message);
    }

    /**
     * <p>
     * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     * 
     * @param resourceType
     *        The type of resource in the Identity Store service, which is an enum object. Valid values include USER,
     *        GROUP, and IDENTITY_STORE.
     * @see ResourceType
     */

    @com.fasterxml.jackson.annotation.JsonProperty("ResourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * <p>
     * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     * 
     * @return The type of resource in the Identity Store service, which is an enum object. Valid values include USER,
     *         GROUP, and IDENTITY_STORE.
     * @see ResourceType
     */

    @com.fasterxml.jackson.annotation.JsonProperty("ResourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    /**
     * <p>
     * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     * 
     * @param resourceType
     *        The type of resource in the Identity Store service, which is an enum object. Valid values include USER,
     *        GROUP, and IDENTITY_STORE.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ResourceType
     */

    public ResourceNotFoundException withResourceType(String resourceType) {
        setResourceType(resourceType);
        return this;
    }

    /**
     * <p>
     * The type of resource in the Identity Store service, which is an enum object. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     * 
     * @param resourceType
     *        The type of resource in the Identity Store service, which is an enum object. Valid values include USER,
     *        GROUP, and IDENTITY_STORE.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ResourceType
     */

    public ResourceNotFoundException withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    /**
     * <p>
     * The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     * <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     * <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it is
     * created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the case that
     * the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that identity
     * store will be in the format of <code>UUID</code>. Otherwise, it will be in the <code>1234567890-UUID</code>
     * format.
     * </p>
     * 
     * @param resourceId
     *        The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     *        <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     *        <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when
     *        it is created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the
     *        case that the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for
     *        that identity store will be in the format of <code>UUID</code>. Otherwise, it will be in the
     *        <code>1234567890-UUID</code> format.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("ResourceId")
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * <p>
     * The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     * <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     * <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it is
     * created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the case that
     * the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that identity
     * store will be in the format of <code>UUID</code>. Otherwise, it will be in the <code>1234567890-UUID</code>
     * format.
     * </p>
     * 
     * @return The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     *         <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     *         <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource
     *         when it is created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value.
     *         In the case that the identity store is migrated from a legacy SSO identity store, the
     *         <code>ResourceId</code> for that identity store will be in the format of <code>UUID</code>. Otherwise, it
     *         will be in the <code>1234567890-UUID</code> format.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("ResourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * <p>
     * The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     * <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     * <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it is
     * created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the case that
     * the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that identity
     * store will be in the format of <code>UUID</code>. Otherwise, it will be in the <code>1234567890-UUID</code>
     * format.
     * </p>
     * 
     * @param resourceId
     *        The identifier for a resource in the identity store, which can be used as <code>UserId</code> or
     *        <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     *        <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when
     *        it is created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the
     *        case that the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for
     *        that identity store will be in the format of <code>UUID</code>. Otherwise, it will be in the
     *        <code>1234567890-UUID</code> format.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceNotFoundException withResourceId(String resourceId) {
        setResourceId(resourceId);
        return this;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @param requestId
     *        The identifier for each request. This value is a globally unique ID that is generated by the Identity
     *        Store service for each sent request, and is then returned inside the exception if the request fails.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("RequestId")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @return The identifier for each request. This value is a globally unique ID that is generated by the Identity
     *         Store service for each sent request, and is then returned inside the exception if the request fails.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("RequestId")
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the Identity Store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @param requestId
     *        The identifier for each request. This value is a globally unique ID that is generated by the Identity
     *        Store service for each sent request, and is then returned inside the exception if the request fails.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceNotFoundException withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

}
